
{a quick little demo program to show the use of SDImage and ExpBox}
{written by Michael Day 14 february 1989}
{released to the public domain}

program sditest;

uses crt,graph,sdimage,expbox;

const
    xSpeed   : word = 50;  {explosion speed}
    xStep    : byte = 5;    {explosion count}
    xStyle   : byte = 0;    {explosion style}
    xSound   : byte = $10;  {explosion sound}
    xRect    : byte = $80;  {explosion rectangles}
    xColor   : byte = blue; {explosion color}
    xPattern : byte = solidfill; {explosion pattern}
    xrColor  : byte = yellow; {explosion rectangle}

var
    gr,gd:integer;
    ch : char;
    IT,IE:integer;
    x1,y1,x2,y2:integer;
    StyleIt : integer;

function fstr(I:integer):string;  {functionalized Str procedure}
var S:string[8];
begin
  str(I,S);
  fstr := S;
end;

procedure bomb(I:integer);  {rats! show what went wrong}
begin
  setfillstyle(solidfill,black);
  bar(0,0,100,10);
  setcolor(green);
  moveto(0,0);
  outtext('OOPS!:'+fstr(i)+':'+fstr(ImageError));
  Halt;
end;

procedure ShowStr(S:string);   {display a string clipped to window edge}
var x,y:integer;
begin
  y := y1+4;
  while y < (succ(y2)-TextHeight('X')) do
  begin
    x := x1+4;
    while x < x2 do
    begin
      moveto(x,y);
      outtext(copy(S,1, pred(x2 div TextWidth('X')) - (x div TextWidth('X'))));
      x := x + (length(S)*TextWidth('X'))+TextWidth('X');
    end;
    y := y + TextHeight('X');
  end;
end;


{--------------------------------------------}
{here is where it all begins}

begin
  gr := 0;
  gd := 0;
  initgraph(gr,gd,'');

 {  to direct the image to a ram disk, put your path in here }
{  if not SetImagePath('F:\SDI') then bomb(4); }

  x1 := 20;            {defines the image area we will be using}
  y1 := 20;
  x2 := 620;
  y2 := 180;

  {this allows you to change the buffer size}
  {if you want to see how it affects things}
{ if not AllocImageBuf(1,1000) then Bomb(3); }

  moveto(1,1);
  outtext('The following special effects are available:');
  for IT := 0 to 7 do       {create the images}
  begin
    setfillstyle(solidfill,black);
    bar(x1,y1,x2,y2);
    setColor(white);
    case IT of
      0:ShowStr('Pull Down (Vertical)');
      1:ShowStr('Pull Up (Vertical)');
      2:ShowStr('Pull Right (Horizontal)');
      3:ShowStr('Pull Left (Horizontal)');
      4:ShowStr('Merge Vertical');
      5:ShowStr('Expand Vertical');
      6:ShowStr('Merge Horizontal');
      7:ShowStr('Expand Horizontal');
    end;
    StyleIt := IT or $10; {<- $10 means use compression}
    if not saveImage(IT,1, x1,y1,x2,y2, StyleIT) then bomb(1);
    setfillstyle(solidfill,black);
    bar(x1,y1,x2,y2);
  end;

  setfillstyle(solidfill,black); {now clear the dispay}
  bar(0,0,GetMaxX,GetMaxY);
  setColor(white);

  IT := 0;    {now we show all the great stuff we can do}
  IE := 0;
repeat
  xStyle := ie or xRect {or xSound};
  ExplodeBox(x1-10,y1-10,x2+10,y2+10,
             xSpeed,xStep,xStyle,
             xColor,xPattern,xrColor);

  if not displayImage(IT,1, false) then bomb(2);
  delay(1000);
  inc(IT);
  if IT > 7 then IT := 0;
  Inc(IE);
  if IE > 8 then IE := 0;

  setfillstyle(solidfill,black);  {clear the display between images}
  bar(0,0,GetMaxX,GetMaxY);
  setColor(white);
  ch := #255;
  if keypressed then ch := readkey;  {stop when they tell us to}
until ch < #32;

end.
