uses crt,dos;
var
  fileinfo:searchrec;
  attr:word;
  newatr:string;
  fil:file;
  i:byte;
  ch:char;
procedure help;
begin
  if paramcount=1 then if (pos('N',paramstr(1))>0) or (pos('n',paramstr(1))>0) then begin
    assign(output,'');
    rewrite(output);
  end;
  writeln('Usage: setfatr filename attributes');
  writeln('Filename is any legal DOS file specification. Wild cards are OK.');
  writeln('Attributes are uppercase to set an attribute and lowercase to');
  writeln('remove one. If there is more than one attribute setting DO NOT');
  writeln('seperate them by spaces.');
  writeln('The attributes and options are as follows:');
  writeln(' --<<**attributes**>>--');
  writeln('  R        Read only');
  writeln('  H        Hidden');
  writeln('  S        System');
  writeln('  A        Archive');
  writeln(' --<<**options**>>--');
  writeln('  L        List only, do not set attributes');
  writeln('  N        Use bios to write to screen (you can use redirection)');
  writeln('All other characters will be ignored. If there are no valid attribute');
  writeln('or option settings, the files will just be listed with their attributes.');
  writeln('Entering N as the only parameter will use bios to write the help.');
  writeln('This enables you to use redirection. Two examples of redirection are:');
  writeln('             setfatr N>help.dat');
  writeln('             setfatr *.* N>attr.dat');
  writeln('You can use >> insted of > to append to an existing file');
  halt;
end;

begin
  if paramcount<2 then help;
  newatr:=paramstr(2);
  if (pos('N',newatr)>0) or (pos('n',newatr)>0) then begin
    assign(output,'');
    rewrite(output);
  end;
  findfirst(paramstr(1),anyfile,fileinfo);
  while doserror=0 do begin
    if keypressed then begin
      writeln('Press any key to continue');
      ch:=readkey;
      repeat until keypressed;
      ch:=readkey;
    end;
    write(fileinfo.name,'':30-length(fileinfo.name)); {print file name}
    assign(fil,fileinfo.name);
    getfattr(fil,attr);
    for i:=1 to length(newatr) do
      case newatr[i] of
        'r':attr:=attr and not($01);     {not read only}
        'R':attr:=attr or $01;           {read only}
        'h':attr:=attr and not($02);     {not hidden}
        'H':attr:=attr or $02;           {hidden}
        's':attr:=attr and not($04);     {not system}
        'S':attr:=attr or $04;           {system}
        'a':attr:=attr and not($20);     {not archive}
        'A':attr:=attr or $20;           {archive}
      end;
    if (pos('L',newatr)=0) and (pos('l',newatr)=0) then setfattr(fil,attr);
    if attr and $01=$01 then write('Read only ');   {print attributes}
    if attr and $02=$02 then write('Hidden ');
    if attr and $04=$04 then write('System ');
    if attr and $20=$20 then write('Archive ');
    writeln;
    findnext(fileinfo);
  end;
end.

