
Program BackTrak;

Uses Dos;

  { pops menus off the ram resident menu stack }

const MaxStack = 40;    { menu stack maximum size }
      SLBBSID = $736C;  { code for interrupt identifications }
      RSInt = $7E;      { modem driver interrupt }

type ExecType = (Display,Execute);
     Ansitype = (GENERIC,PROCOMM,STANDARD);

     { Following is the data format in which the menu stack is stored
       in memory during door execution. With care, door programs can
       modify this data area in order to produce changes in menu
       execution when control returns from the door to Searchlight. }

     MenuData = Record
       Count: integer;          { # of active menus }
       FilesCount: integer;     { menu that called files system, 0 if none }
       Menus: Array[1..MaxStack] of record
         Name: string[8];       { menu filename }
         Pos: integer;          { cursor position within menu }
         Mode: ExecType;        { display/execute }
       end;
     end;

Type SlDataType = record   { public area; contains menu stack }
      PROGID: string[6];                { Program ID }
      carrier: boolean;                 { carrier check enable }
      writeprotect: boolean;            { disk write protection }
      aborttype: byte;                  { 0=no abort, 1=terminate, 2=reboot }
      rsactive: boolean;                { set if rs232 active }
      ansi: boolean;                    { user ANSI mode }
      color: boolean;                   { user COLOR mode }
      directvid: boolean;               { system DirectVid mode }
      curratt: byte;                    { current video attribute }
      commtype: byte;                   { run parameter }
      idletime: word;                   { idle limit (seconds) }
      lastkey: boolean;                 { TRUE = last key from local kbd }
      OldVector: array[$00..$7F] of pointer;   { old user int vectors }
      AnsiMode: AnsiType;               { caller's ansi mode }
      SLMenuStack: MenuData;            { active menu stack }
    end;

var MenuStack: ^MenuData;
    n,i: integer;


Procedure InitStack;
var SLData: ^SLDataType;
    p: pointer;
    regs: registers;
Begin
  SLData:=Nil;
  GetIntVec($79,p);
  if longint(p)=SLBBSID then begin        { check SL installation }
    regs.ax:=$C7;
    regs.cx:=$00;
    Intr(RSInt,regs);                     { get public data area pointer }
    if (regs.cx=SLBBSID)
      then SLData:=Ptr(regs.ax,regs.bx);
  end;
  if (SLData<>Nil)
    then MenuStack:=@Sldata^.SLMenuStack
    else MenuStack:=Nil;  { slbbs not loaded }
end;



Begin
  n:=1;
  if ParamCount>0 then begin    { read number off command line }
    Val(ParamStr(1),n,i);
    if (i<>0) then n:=0;
  end;

  if (n>0) then begin
    InitStack;                      { point to menu stack in memory }
    if (menustack<>Nil) then
    with menustack^ do begin
      if count>1 then begin
        i:=count;
        count:=count-n;
        if count<1 then count:=1;   { don't back up past first menu }
        if (filescount>0) and (count<=filescount)
          then count:=filescount+1; { don't back out of files system }
        if (count<>i) and (Menus[count].mode=Execute)
          then inc(Menus[count].pos);  { inc position to prevent loops }
      end;
    end;
  end;

end.
