
Program Sample3;

  { Sample program to list users in alphabetical order via recursion }


Uses Filedef,Users;

var r: longint;
    localuser: usertype;


    Procedure ProcessUser (var user: usertype);
    Begin
      writeln(user.name,', ',user.location);
    end;


    Procedure ReadUserList (n: longint);
    Begin
      ReadUser(localuser,n);
      if localuser.leaf.left<>0 then begin
        ReadUserList(localuser.leaf.left);    { process left branch }
        ReadUser(localuser,n);                { re-read current record }
      end;

      ProcessUser(localuser);                 { perform action on user }

      if (localuser.leaf.right<>0)            { process right branch }
        then ReadUserList(localuser.leaf.right);
    end;

    { Notice that the recursive procedure does not declare any local
      variables, and that all processing of the user (ie. printing out
      of the name) is done in a separate procedure. This helps keep
      the required stack space to a minimum. }


Begin
  if OpenFiles([CONFIGF,NODESF]) and OpenUserFile then begin

    ReadUserList(UserFileRoot);
      { begin recursive procedure at user file root }

    CloseUserFile;
    CloseAllFiles;
  end
  else writeln('Could not open CONFIG File');

end.