program SortDemo;
   uses Sorting,TypeSpec,DistSort,Crt;
{=============================================}
{            James L. Allison                 }
{            1703 Neptune Lane                }
{            Houston, Texas  77062            }
{            Dec 22, 1988                     }
{=============================================}

{ Please feel free to use any part of this in any of your programs.}

var
   I:integer;
   Jump:integer;

(*---------------------------------------------------------------------*)
function Rnd(Xlo,Xhi:integer):integer;
   {random from xlo to xhi INCLUSIVE}
   begin
      Rnd:=Random(1+Xhi-Xlo)+Xlo;
   end;
(*---------------------------------------------------------------------*)
function Prompt:integer;
var
   Temp:Char;
   begin
      repeat
         ClrScr;
         WriteLn('When the random array has been loaded,');
         WriteLn('press any key to start the sort.');
         WriteLn('(After the sort, press any key to continue.)');
         WriteLn('');
         WriteLn('1 -- LoopSort');
         WriteLn('2 -- BubbleSort');
         WriteLn('3 -- ShellSort');
         WriteLn('4 -- QuickSort');
         WriteLn('5 -- DistributionSort');
         WriteLn('6 -- EXIT');
         WriteLn('');
         Write('Select>');
         Temp:=ReadKey;
      until(Temp>='1') and (Temp<='6');
      Prompt:=ord(Temp)-ord('1')+1;
   end;

var
   P:^List;
   Q:^Screen_Buffer;
   Key:char;
const
   N=2000;
   begin
      if Lastmode=Mono     {set video memory}
         then P:=ptr($B000,$0000)
         else P:=ptr($B800,$0000);
      Q:=Pointer(P);
      repeat
         Jump:=Prompt;
         ClrScr;
         if Jump=6 then HALT;
         RandSeed:=12345;  {so all tests are against the same data}
         for I:=0 to N-1 do Q^[I][Value]:=Rnd(ord('A'),ord('z'));
         Key:=ReadKey;
         case Jump of
            1:LoopSort         (P^,Less,N);
            2:BubbleSort       (P^,Less,N);
            3:ShellSort        (P^,Less,N);
            4:QuickSort        (P^,Less,N);
            5:DistributionSort (P^,N);
            6:begin
                ClrScr;
                HALT;
              end;
         end {case};
         Key:=ReadKey;
      until false;
   end.

