UNIT StackPtr;


                              INTERFACE

   TYPE  ElementType = RECORD (* Type of the elements on the stack *)
                           PlateCode: PACKED ARRAY [1..6] OF Char;
                           MoveCount: Integer
                       END;  (* ElementType *)

         StackType = ^NodeType;
         NodeType = RECORD
                       Info: ElementType;
                       PreviousNode: StackType
                    END;  (* NodeType *)


   PROCEDURE StackInit (VAR Stack: StackType);
   FUNCTION StackEmpty (Stack: StackType): Boolean;
   PROCEDURE StackPush (VAR Stack: StackType; NewElem: ElementType);
   PROCEDURE StackPop (VAR Stack: StackType; VAR TopElem: ElementType);
   PROCEDURE StackPeek (Stack: StackType; VAR TopElem: ElementType);
   PROCEDURE StackClear (VAR Stack: StackType);


                                   IMPLEMENTATION



   PROCEDURE StackInit (VAR Stack: StackType);

      BEGIN  (* StackInit *)
         Stack := NIL   
      END;   (* StackInit *)


   FUNCTION StackEmpty (Stack: StackType):Boolean;

      BEGIN  (* StackEmpty *)
         StackEmpty := Stack = NIL
      END;   (* StackEmpty *)

   PROCEDURE StackPush (VAR Stack: StackType; NewElem: ElementType);

      VAR Temp: StackType;  (* used to allocate space for the new stack element *)

      BEGIN  (* StackPush *)
         IF StackEmpty (Stack) THEN
            BEGIN  (* this is the first element in the stack *)
               New (Stack);   (* allocate space for the first element *)
               Stack^.Info := NewElem;  (* put the value of the first element onto the stack *)
               Stack^.PreviousNode := NIL  (* indicate that this is the last node of the stack *)
            END    (* this is the first element in the stack *)
               ELSE
                  BEGIN  (* there is at least one element in the stack *)
                     New (Temp);  (* allocate space for the new node *)
                     Temp^.Info := NewElem;  (* put the value of the new element onto the stack *)
                     Temp^.PreviousNode := Stack;  (* link it to the other elements of the stack *)
                     Stack := Temp;  (* make Stack point to the new top of the stack *)
                  END    (* there is at least one element in the stack *)
      END;   (* StackPush *)


   PROCEDURE StackPop (VAR Stack: StackType; VAR TopElem: ElementType);

      VAR Temp: StackType;  (* used to point to the top of the stack *)

      BEGIN  (* StackPop *)
         IF NOT StackEmpty (Stack) THEN
            BEGIN   (* there is at least one element on the stack *)
               TopElem := Stack^.Info;   (* return the value of the top element of the stack *)

               (* now remove the top element from the stack *)

               Temp := Stack;  (* save the pointer to the top of the stack *)
               Stack := Stack^.PreviousNode; (* disconnect this element from the stack *)
               Dispose (Temp);  (* deallocate space used by the top element *)
            END;    (* there is at least one element on the stack *)
      END;   (* StackPop *)


   PROCEDURE StackPeek (Stack: StackType; VAR TopElem: ElementType);

      VAR Temp: StackType;  (* used to point to the top of the stack *)

      BEGIN  (* StackPeek *)
         IF NOT StackEmpty (Stack) THEN  (* if the stack is not empty ... *)
               TopElem := Stack^.Info;   (* return the value of the top element of the stack *)
      END;   (* StackPeek *)


   PROCEDURE StackClear (VAR Stack: StackType);

      VAR Dummy: ElementType;  (* used to hold retrieved elements *)

      BEGIN  (* StackClear *)
         WHILE NOT StackEmpty (Stack) DO
            StackPop (Stack, Dummy)
      END;   (* StackClear *)

 END.  (* of Unit StackPtr *)


