Program SwapTest;      (* By Kevin A. Kwast *)
{$M 8192,0,0}
(**********************************************************************)
(** This program illustrates a DOS shell spawned from a Pascal       **)
(** program.  If you have Turbo Debugger or something similar, you   **)
(** can examine what is left in memory and notice that the constant  **)
(** strings and the Str variable (in data) are NOT in memory.  The   **)
(** literal strings in the program area WILL be in memory however.   **)
(** This is because strings quoted in the code will be placed in the **)
(** code segment.  The $M compiler directive specifies a 8192 byte   **)
(** stack and no heap.  Otherwise, the stack would be at the default **)
(** 16K size, with a heap that will fill all available memory.  That **)
(** will mean that the program memory block to be swapped will be a  **)
(** very large block (all available memory).  Using the $M compiler  **)
(** directive allows you to change these default memory usages and   **)
(** make more efficient use of memory.  If you don't use the heap,   **)
(** be sure to set it to 0 so that no heap will be allocated.  Just  **)
(** for grins, compile this same program using the standard Exec     **)
(** procedure and notice the differences!               --Kevin      **)
(**********************************************************************)

{ Notice that SwapUnit always comes last on the Uses line! }
Uses Dos, SwapUnit;
Const
     AnyArray = 'This is a constant string.';
     AnotherArray = 'This is another constant string.';

     FinalMessage = 'Thank you for trying SWAPUNIT.';

Var
   Result: Word;

   Str: String;

Begin
     WriteLn('This is the swap test (using SwapUnit TPU).');
     WriteLn('EMS 4.0 Test Result: ',CheckEMS);
     WriteLn('XMS Test Result: ',CheckXMS);

     WriteLn('Going to the shell... Type EXIT to return..');

     Str:=GetEnv('COMSPEC');
{ For those without the GetEnv function, just use a declaration like: }
{    Str:='C:\COMMAND.COM'; }
     Result:=SwapExec(Str,'','SWAP.FIL',SwapToAny);

{ SwapExec is called to execute COMMAND.COM with no command line.  This }
{ begins a DOS shell.  If swapping to disk is necessary, the swap file  }
{ will be called SWAP.FIL; the SwapToAny parameter specifies that all 3 }
{ forms of swapping should be tried.  XMS, then EMS, and then Disk.     }

     WriteLn('Returned from the swap.. Results:  High byte = ',Hi(Result),' Low byte = ',Lo(Result));
     WriteLn;
     WriteLn(FinalMessage);
     WriteLn;
End.