{$A+,B-,D+,E-,F-,I+,L+,N-,O-,R-,S-,V-}
{$M 1024,5120,5120}
Program RemovePopUpDice;

{ This is the companion program to POPDICE.  This short program removes }
{ the resident program from memory if it is loaded and if it is safe to }
{ do so.                                                                }

Uses Unhook;

Const
  Name = 'POPDICE';
  Signature = $89; { This value MUST be the same as the resident program's }

Var
 Result : Integer;

Begin
  WriteLn('Attempting to remove ',Name,' from program memory.');
  If Installed(Signature)              { is it installed?    }
    Then Begin                         { yes.                }
      If OkToRemove(Signature)         { can it be unloaded? }
        Then Begin
          RemoveProgram(Signature);    { yes. remove it.     }
          WriteLn(Name,' successfully removed.');
          Result := 0;
        End
      Else Begin
        WriteLn('Unable to remove ',Name,' from memory.');  { unsafe }
        Result := 2;
      End
    End
  Else Begin
    WriteLn(Name,' is not installed.'); { program not found in memory. }
    Result := 1;
  End;
  Halt(Result);
End.
