{ This provides capabilities similar to argc/argv in C. You can now
  read the argument list from your TURBO Pascal program. `argc' is
  actually a function that returns the number of parameters on the
  command line. Spaces are the separators between parameters. If the
  parameter is enclosed in quotes ('), then any characters can appear.
  If you want a quote, put two in the command line parameter.

Example

    cmd 'this is the first' and 'this is the ''third'' argument'

This will return argc=3.

You can retrieve the arguments by calling argv(#)

Example
   if the above was the command line, then the program

      for i := 1 to argc do
         writeln('argv(',i,') =<',argv(i),'>');

would print

    argv(1) =<this is the first>
    argv(2) =<and>
    argv(3) =<this is the 'third' argument>

            Jim Holtman
            35 Dogwood Trail
            Randolph, NJ 07869
            (201) 361-3395
}

type
    arglist_string = string[80];
const
    arglist_max = 20;
    arglist_number : integer = -1;
var
    argvlist : array[1..arglist_max] of ^arglist_string;
function argv(num : integer) : arglist_string;

var
    argument : arglist_string absolute cseg:$80;
    newparm,parmline : arglist_string;
    i,j : integer;
    state : (leading_ws, non_quote, quoted, end_quote);
    inchar : char;

    procedure saveparm;
    begin
      if arglist_number < arglist_max then begin
        arglist_number := arglist_number+1;
        new(argvlist[arglist_number]);
        argvlist[arglist_number]^ := newparm;
        newparm := '';
        end;
      end;

begin
    if arglist_number = -1 then begin
        arglist_number := 0;
        parmline := argument+' ';
        state := leading_ws;
        newparm := '';
        for i := 1 to length(parmline) do begin
            inchar := parmline[i];
            case state of

                leading_ws: begin
                    if inchar = '''' then state := quoted
                    else if inchar <> ' ' then begin
                        newparm := newparm+inchar;
                        state := non_quote;
                        end;
                    end;

                non_quote: begin
                    if inchar = ' ' then begin
                        saveparm;
                        state := leading_ws;
                        end
                    else newparm := newparm+inchar;
                    end;

                quoted: begin
                    if inchar = '''' then state := end_quote
                    else newparm := newparm+inchar;
                    end;

                end_quote: begin
                    if inchar = '''' then begin
                        newparm := newparm+inchar;
                        state := quoted;
                        end
                    else if inchar <> ' ' then begin
                        newparm := newparm+inchar;
                        state := non_quote;
                        end
                    else begin
                        saveparm;
                        state := leading_ws;
                        end;
                end;
            end;
        end;
        end;
    if (num > 0) and (num <= arglist_number) then
        argv := argvlist[num]^
    else argv := '';
    end;

function argc : integer;
var
    dummy : arglist_string;

begin
    if arglist_number = -1 then dummy := argv(1); {force evaluation}
    argc := arglist_number;
    end;
                                                                                                                                                        