{ ************************************************************************}
{ ----------------------------  GetDir  --------------------------------- }
{ ************************************************************************}
{ Turbo Pascal procedure to scan a disk's directory under PC/MSDos 2.0    }
{ Written orginally by:    Jim McCarthy                                   }
{                          Technical Support                              }
{                          Borland Intl.                                  }
{ Re-worked into an easy to use $Include file by                          }
{                          Clark W. Walker                                }
{                          CompuServe 76010,346                           }
{ ************************************************************************}
   TYPE
      registers = record
                    ax, bx, cx, dx, bp, si, di, ds, es, flags : integer;
                  end;
      string80 = string[80];
   VAR
      OurDTA : array [ 1..43 ] of byte;    { Data Transfer Area buffer }
      CurDTAseg,                           { DTA segment before exicution }
      CurDTAofs,                           { DTA offset    "        "     }
      OurDTAseg,                           { DTA segment and offset set after }
      OurDTAofs          : integer;        { start of program }
      regs               : registers;      { register pack for the DOS call }
{ --------------------------------------------------------------------------}
{     This procedure will setup for or reset the DTA in preparation         }
{ --------------------------------------------------------------------------}
{ --------------------------------------------------------------------------}
PROCEDURE DirSetup(InitReset: String80 ;
                   var error: Integer  );
VAR
   I : Integer;
BEGIN
   Error := 0;
   IF InitReset = 'INIT' then
      BEGIN           {---------- Initialization processes ------------}
         For I := 1 to 43 do                    {Initialize our DTA Buffer}
             OurDTA[I]:=0;

         regs.ax := $2F00;                      { Save Current DTA pointer}
         Intr($21,regs);                        { to be restored later    }
         CurDTASeg := regs.es;
         CurDTAOfs := regs.bx;
         error := regs.ax and $FF;

         if error = 0 then
            BEGIN
            OurDTAseg := seg(OurDTA);           {Point DOS to our        }
            OurDTAofs := ofs(OurDTA);           {DTA Buffer              }
            regs.ax := $1A00;
            regs.ds := OurDTASeg;
            regs.dx := OurDTAOfs;
            Intr($21,regs);
            error := regs.ax and $FF;
            END;
      END
   Else
      BEGIN            {-------------- Reset Processes ------------------}
         regs.ax := $1A00;
         regs.ds := CurDTASeg;
         regs.dx := CurDTAOfs;
         Intr($21,regs);
         error := regs.ax and $FF;
         END;
END;

{ --------------------------------------------------------------------------}
{   DirGet gets the first/next drectory entry of a particular file mask.    }
{   Also reads directories and volumne info                                 }
{ --------------------------------------------------------------------------}
{ Func:    'FIRST' or 'NEXT'                                                }
{ Asciiz:  Drive:\Path\Filename.Ext                                         }
{ FileName:Filename.Ext                                                     }
{ Option:  1=volumne read                                                   }
{          2=directores read                                                }
{          3=standard files read                                            }
{  Note: options could be added to read system and hidden files             }
{ --------------------------------------------------------------------------}
PROCEDURE DirGet  (Func     : String80 ;
                   Asciiz   : String80 ;
               var FileName : String80 ;
                   Option   : Integer  ;
               var Error    : Integer  );
VAR
     I : integer;

BEGIN
    error := 0;

    If Func = 'FIRST' then
       BEGIN
       asciiz[length(asciiz)+1]:=chr(0); { Terminate name with hex00 }
       regs.ax := $4E00;          { Get first directory entry }
       regs.ds := seg(Asciiz);    { Point to the file mask }
       regs.dx := ofs(Asciiz);
       regs.dx := regs.dx + 1;    { Point past string's length byte }
       regs.cx := Option;
       END
    else
       regs.ax := $4F00;          {Get next directory entry}

    Intr($21,regs);               { Execute MSDos call }
    error := regs.ax and $FF;     { Get error return }
    I := 1;
    If error = 0 then
    Repeat                        { Get name from the DTA area }
        FileName[I]:=chr(mem[OurDTASeg:OurDTAOfs + 29 + I]);
        I := I + 1;
    Until (not (FileName[I - 1] in [' '..'~']));
    FileName[0]:=chr(I-1)         { set string length because assigning }
                                  { by element does not set length }
END;
                                   