PROGRAM SampPth;
{
   This TURBO PASCAL program is used an example of how to use the
   $INCLUDE file 'PATHS.PAS' which makes, deletes, changes, renames,
   and otherwise gives one complete control over MS/PCDos Rel 2.0 and
   up  PATH support.
}
type
   string80 = string[80];
   registers = record
               ax,bx,cx,dx,bp,si,di,ds,es,flags : integer;
               end;
var
   regs : registers;
   directory : string80;
   error     : integer;
   path      : string80;
   nothing   : string80;
   tempfile  : file of string80;
   Drive     : char;
   DefDirect : string80;

{$I PATHS.PAS}

begin
   writeln('=================================');
   writeln('getting current drive');
   Drive := CurrDrive;
   write('Current drive is:'); writeln(drive);

   writeln('=================================');
   writeln('getting free space of current drive');
   write('Free Space:'); writeln(FreeSpace(drive):9:0);

   writeln('=================================');
   writeln('getting current directory');
   CurrDir('A',DefDirect,error);
   write('error returned was:'); writeln(error);
   writeln(DefDirect);

   writeln('=================================');
   writeln('creating subdirectory');
   if DefDirect = '' then
      directory := 'A:\TEST'                  {must have full drive/path}
   else
      directory := 'A:\'+DefDirect+'\TEST';
   writeln(directory);
   MkDir(directory,error);
   write('error returned was:'); writeln(error);

   writeln('=================================');
   writeln('remove subdirectory A:\TEST');
   RmDir(directory,error);
   write('error returned was:'); writeln(error);

   writeln('=================================');
   writeln('recreating a subdirectory A:\TEST');
   directory := 'A:\TEST';
   MkDir(directory,error);
   write('error returned was:'); writeln(error);

   writeln('=================================');
   writeln('changing to that directory');
   ChDir(directory,error);
   write('error returned was:'); writeln(error);

   writeln('=================================');
   writeln('creating dummy file on directory');
   Assign(TempFile,'A:TempFile.XXX');
   Rewrite(TempFile);
   Close(TempFile);

   writeln('=================================');
   Writeln('changing logged on drive to A:');
   ChgDrive('A');

   writeln('=================================');
   writeln('renaming file on A:\TEST to root directory (now logged on)');
   Directory := 'A:\TEST\TempFile.XXX';
   Path := 'A:\RenFile.YYY';
   RenFile (Directory,Path,error);
   write('error returned was:'); writeln(error);

   writeln('=================================');
   writeln('creating another dummy file on A:\TEST');
   Assign(TempFile,'A:TempFile.NEW');
   Rewrite(TempFile);
   Close(TempFile);

   writeln('=================================');
   writeln('now deleteing the file');
   directory := 'A:\TEST\TempFile.NEW';
   DelFile(directory,error);
   write('error returned was:'); writeln(error);

   writeln('=================================');
   writeln('cleaning up, back to the defaults');
   ChgDrive(Drive);
   ChDir(DefDirect,error);

END.                                                                                                                              