Procedure Scroll (First_Row,Last_Row,First_Column,Last_Column,
  Lines_To_Scroll: Integer);
{Scroll scrolls the indicated region of the screen.  If Lines_To_Scroll
 is positive the screen scrolls up, if negative it scrolls down, if 0 the
 entire region is blanked.
 Written by Albert Bailey.}
Type
  RegPack=record
    Ax,Bx,Cx,Dx,Bp,Si,Di,Ds,Es,Flags: Integer;
  End;
Var
  Reg1: Regpack;
Begin
  Reg1.Cx:=(First_Row Shl 8) Or First_Column;
  Reg1.Dx:=(Last_Row Shl 8) Or Last_Column;
  Reg1.Bx:=0;
  If (Lines_To_Scroll >= 0) Then
    Reg1.Ax:=$0600 Or Lines_To_Scroll
  Else
    Reg1.Ax:=$0700 Or Abs(Lines_To_Scroll);
  Intr($10,Reg1);
End;
                                                                                                    