program where;
uses dos;

type str80=string[80];

var numofiles:integer;

procedure instructions;
begin
  writeln ('Whereis ');
  writeln ('   Usage: Whereis [filename.ext]');
  writeln ('      or  Whereis *.com');
  writeln ('          searches whole disk for .COM files');
end;

procedure split(name:str80; var dir,filespec:str80);
var i:integer;
begin
  i:=length(name);
  while (i>0) and not (name[i] in [':','\']) do i:=i-1;
  dir:=copy (name,1,i);
  if dir[i] <> '\' then dir:=dir+'\';
  filespec:=copy(name,i+1,length(name))
end;

function out (a:integer):string;
var s:string[2];
begin
  if a < 10 then
  begin
    str(a:1,s);
    out:='0'+s
  end
    else
    begin
      str(a:2,s);
      out:=s;
     end;
end;

procedure searchdirectory(path,filespec:str80);
var fileinfo:searchrec;
    f:file;
    time:longint;
    dt:datetime;
    am:string[2];
begin
  findfirst(path+filespec,$3f,fileinfo);
  while doserror=0  do
  begin
    assign (f,path+fileinfo.name);
    {$I-}
    reset(f);
    {$I+}
    if ioresult = 0 then
    begin
      numofiles:=numofiles+1;
      getftime(f,time);
      unpacktime (time,DT);
      close (f);
      dt.year:=dt.year-1900;
      write (fileinfo.size:7,'   ');
      write (out(dt.month),'/',out(dt.day),'/',out(dt.year),'    ');
      if dt.hour<13 then am:='a' else
      begin
        dt.hour:=dt.hour-12;
        am:='p';
      end;
      if dt.hour=0 then dt.hour:=12;
      write (out(dt.hour),':',out(dt.min),am,'    ');
      write (path);
      for time:=1 to length(fileinfo.name) do
      if fileinfo.name[time] in ['A'..'Z'] then
      write (chr(ord(fileinfo.name[time])+ord('a')-ord('A')))
      else
      write (fileinfo.name[time]);
      writeln;
    end;
    findnext(fileinfo);
  end;
  findfirst (path+'*.*',directory,fileinfo);
  while doserror = 0 do
  begin
    if ((fileinfo.attr and directory) >0) and
        (fileinfo.name <> '.') and
        (fileinfo.name <> '..') then
    searchdirectory(path+fileinfo.name+'\',filespec);
    findnext (fileinfo)
  end
 end;
 {main program}

 var dir,filespec:str80;
     temp:integer;
 begin
  numofiles:=0;
  temp:=filemode;
  filemode:=0;
  if paramcount =0 then
  instructions
  else
  begin
    split(paramstr(1),dir,filespec);
    searchdirectory(dir,filespec);
    writeln (numofiles,' files found');
 end;
  filemode:=temp;
  end.

