program ziptest;

(*                                                      *)
(* Released to the public domain for any use whatsoever *)
(* By : William L. Mabee, CRNA                          *)
(*                                                      *)

type
  str2   = string[2];
  str12  = string[12];

procedure validate_state(state : str2; var good : boolean;
                   var ziprange : str12; var statenum : byte);
VAR
  STATESET : SET OF BYTE;
BEGIN
  IF STATE = 'AL' THEN STATENUM := 1;
  IF STATE = 'AK' THEN STATENUM := 2;   (* Alaska *)
  IF STATE = 'AZ' THEN STATENUM := 3;
  IF STATE = 'AR' THEN STATENUM := 4;
  IF STATE = 'CA' THEN STATENUM := 5;
  IF STATE = 'CO' THEN STATENUM := 6;
  IF STATE = 'CT' THEN STATENUM := 7;
  IF STATE = 'DE' THEN STATENUM := 8;
  IF STATE = 'DC' THEN STATENUM := 9;
  IF STATE = 'FL' THEN STATENUM := 10;
  IF STATE = 'GA' THEN STATENUM := 11;
  IF STATE = 'HI' THEN STATENUM := 12;
  IF STATE = 'ID' THEN STATENUM := 13;
  IF STATE = 'IL' THEN STATENUM := 14;
  IF STATE = 'IN' THEN STATENUM := 15;
  IF STATE = 'IA' THEN STATENUM := 16;
  IF STATE = 'KS' THEN STATENUM := 17;
  IF STATE = 'KY' THEN STATENUM := 18;
  IF STATE = 'LA' THEN STATENUM := 19;
  IF STATE = 'ME' THEN STATENUM := 20;              (* Maine *)
  IF STATE = 'MD' THEN STATENUM := 21;
  IF STATE = 'MA' THEN STATENUM := 22;
  IF STATE = 'MI' THEN STATENUM := 23;              (* Mich  *)
  IF STATE = 'MN' THEN STATENUM := 24;
  IF STATE = 'MS' THEN STATENUM := 25;
  IF STATE = 'MO' THEN STATENUM := 26;
  IF STATE = 'MT' THEN STATENUM := 27;
  IF STATE = 'NE' THEN STATENUM := 28;
  IF STATE = 'NV' THEN STATENUM := 29;
  IF STATE = 'NH' THEN STATENUM := 30;
  IF STATE = 'NJ' THEN STATENUM := 31;
  IF STATE = 'NM' THEN STATENUM := 32;
  IF STATE = 'NY' THEN STATENUM := 33;
  IF STATE = 'NC' THEN STATENUM := 34;
  IF STATE = 'ND' THEN STATENUM := 35;
  IF STATE = 'OH' THEN STATENUM := 36;
  IF STATE = 'OK' THEN STATENUM := 37;
  IF STATE = 'OR' THEN STATENUM := 38;
  IF STATE = 'PA' THEN STATENUM := 39;
  IF STATE = 'RI' THEN STATENUM := 40;
  IF STATE = 'SC' THEN STATENUM := 41;
  IF STATE = 'SD' THEN STATENUM := 42;
  IF STATE = 'TN' THEN STATENUM := 43;
  IF STATE = 'TX' THEN STATENUM := 44;
  IF STATE = 'UT' THEN STATENUM := 45;
  IF STATE = 'VT' THEN STATENUM := 46;
  IF STATE = 'VA' THEN STATENUM := 47;
  IF STATE = 'WA' THEN STATENUM := 48;
  IF STATE = 'WV' THEN STATENUM := 49;
  IF STATE = 'WI' THEN STATENUM := 50;
  IF STATE = 'WY' THEN STATENUM := 51;
  IF STATENUM IN [1..51] THEN GOOD := TRUE ELSE GOOD := FALSE;
  CASE STATENUM OF
    1 : ZIPRANGE := '35000..36999';
    2 : ZIPRANGE := '99500..99999';
    3 : ZIPRANGE := '85000..86599';
    4 : ZIPRANGE := '71600..72999';
    5 : ZIPRANGE := '90000..96699';
    6 : ZIPRANGE := '80000..81699';
    7 : ZIPRANGE := '06000..06999';
    8 : ZIPRANGE := '19700..19999';
    9 : ZIPRANGE := '20000..20599';
   10 : ZIPRANGE := '32000..34299';
   11 : ZIPRANGE := '30000..31999';
   12 : ZIPRANGE := '96700..96899';
   13 : ZIPRANGE := '83200..83899';
   14 : ZIPRANGE := '60000..62999';
   15 : ZIPRANGE := '46000..47999';
   16 : ZIPRANGE := '50000..52899';
   17 : ZIPRANGE := '66000..67999';
   18 : ZIPRANGE := '40000..42799';
   19 : ZIPRANGE := '70000..71499';
   20 : ZIPRANGE := '03900..04999';
   21 : ZIPRANGE := '20600..21999';
   22 : ZIPRANGE := '01000..02799';
   23 : ZIPRANGE := '48000..49999';
   24 : ZIPRANGE := '55000..56799';
   25 : ZIPRANGE := '38600..39799';
   26 : ZIPRANGE := '63000..65899';
   27 : ZIPRANGE := '59000..59999';
   28 : ZIPRANGE := '68000..69399';
   29 : ZIPRANGE := '89000..89899';
   30 : ZIPRANGE := '03000..03899';
   31 : ZIPRANGE := '07000..08999';
   32 : ZIPRANGE := '87000..88499';
   33 : ZIPRANGE := '09000..14999';
   34 : ZIPRANGE := '27000..28999';
   35 : ZIPRANGE := '58000..58899';
   36 : ZIPRANGE := '43000..45899';
   37 : ZIPRANGE := '73000..74999';
   38 : ZIPRANGE := '97000..97999';
   39 : ZIPRANGE := '15000..19699';
   40 : ZIPRANGE := '02800..02999';
   41 : ZIPRANGE := '29000..29999';
   42 : ZIPRANGE := '57000..57799';
   43 : ZIPRANGE := '37000..38599';
   44 : ZIPRANGE := '75000..79999';
   45 : ZIPRANGE := '84000..84799';
   46 : ZIPRANGE := '05000..05999';
   47 : ZIPRANGE := '22000..24699';
   48 : ZIPRANGE := '98000..99499';
   49 : ZIPRANGE := '24700..26899';
   50 : ZIPRANGE := '53000..54999';
   51 : ZIPRANGE := '82000..83199';
  END; (* CASE STATENUM *)
END;

(* Demonstration of use *)

var (* globals *)
  zip_range  : str12;
  OK         : boolean;
  state_num  : byte;
  state_name : str2;

(* In actual application you would prompt user for state_name *)

procedure initialize;
begin
  zip_range  := '';
  OK         := false;
  state_num  := 0;
  state_name := '';
end;

begin (* main demo *)
  clrscr;
  initialize;
  State_name := 'MI';
  validate_state(state_name,OK,zip_range,state_num);
  gotoxy(1,10);
  writeln(state_name);
  writeln(OK);
  writeln('Zip Range For ',state_name,' Is ',zip_range);
  writeln('State Number = ',state_num);
end.
