#include <math.h>
#include <stdlib.h>

long rand_table[4096];

short sin_table[4096];
short asin_table[4096];

long  tan_table1[1024];
long  tan_table3[256];
long  tan_table4[256];

short  atan_table1[1024];
short  atan_table2[256];
short  atan_table3[256];
short  atan_table4[256];

short  log2_table[4096];
short  exp2_table[4096];
short  sqrt_table[4096];
//short  cubrt_table[1024];

// these data structures adds up to 22016 bytes

#define MPI 3.1415927464



void gen_fixfloat_tables(){
  double v;
  long i,a;


  for(v=MPI/16384,i=0;i<4096;v+=MPI/8192,i++)
    sin_table[i]=sin(v)*65536.0;


  for(v=1.0/8192,i=0;i<4096;v+=1.0/4096,i++)
    asin_table[i]=65536.0*asin(v)/(2*MPI);


  for(a=8,i=0;i<1024;i++,a+=16)
    tan_table1[i]=65536.0*tan(a*2*MPI/65536);

  for(a=0x3C00+2,i=0;i<256;i++,a+=4)
    tan_table3[i]=65536*tan(a*2*MPI/65536);

  for(a=0x3F00,i=0;i<256;i++,a++)
    tan_table4[i]=65536*tan(a*2*MPI/65536);


  for(a=128,i=0;i<1024;i++,a+=256)
    atan_table1[i]=65536*atan(a/65536.0)/(2*MPI);

  for(a=2048,i=0;i<256;i++,a+=4096)
    atan_table2[i]=65536*atan(a/65536.0)/(2*MPI);

  for(a=65536,i=0;i<256;i++,a+=131072)
    atan_table3[i]=65536*atan(a/65536.0)/(2*MPI);

  for(a=16*65536,i=0;i<256;i++,a+=32*65536)
    atan_table4[i]=65536*atan(a/65536.0)/(2*MPI);


  for(a=8,i=0;i<4096;i++,a+=16)
    log2_table[i]=65536.0*log((65536+a)/65536.0)/log(2.0);
  
  for(a=8,i=0;i<4096;i++,a+=16)
    exp2_table[i]=(exp(log(2)*a/65536.0)-1)*65536;

  for(a=8,i=0;i<4096;i++,a+=16)
    sqrt_table[i]=sqrt(a/65536.0)*65536.0;

/*  for(a=32,i=0;i<1024;i++,a+=64)
//    cubrt_table[i]=sqrt(a/65536.0)*65536.0;
cubrt_table[i]=exp(log(a/65536.0)/3)*65536.0;*/

  for(i=0;i<4096;i++)
    rand_table[i]=(((rand()<<12)+rand())<<12)+rand();
  }

long fftoa(long ff, char *buf){    
  long p,pow;
  long tmp;

  if(!buf) return -1;

  pow=65536*10000;
  p=0;



  if(ff<0){
    buf[0]='-', p++,ff=-ff;
    if(ff==0x80000000) ff=0x7FFFFFFF;          // some numbers aren't possible to negate...
    }

  while(ff/pow==0 && pow>65540) pow/=10;

  while(pow>=65536){
    tmp=ff/pow;
    ff-=tmp*pow;
    buf[p]=tmp+48;
    p++;
    pow=pow/10;
    while (ff/pow>9) pow++;
    }

  if(ff){
    buf[p++]='.';
    while(ff && pow>1){
      tmp=ff/pow;
      ff-=tmp*pow;
      buf[p]=tmp+48;
      p++;
      pow=pow/10;
      while (pow && ff/pow>9) pow++;
      }
    while(buf[p-1]=='0') p--; // cut trailing zeroes
    }



  buf[p]=0;    

  return 0;
  }
    
    
long fftoah(long ff, char *buf){    
  long p,pow;
  long tmp;

  if(!buf) return -1;

  pow=65536*4096;
  p=0;

  if(ff<0) buf[0]='-', p++,ff=-ff;

  while(pow>=65536){
    tmp=ff/pow;
    ff-=tmp*pow;

    if(tmp>9) tmp+='A'-'9'-1;

    buf[p]=tmp+48;
    p++;
    pow>>=4;
    }


    buf[p++]='.';
    while(pow){
      tmp=ff/pow;
      ff-=tmp*pow;

      if(tmp>9) tmp+='A'-'9'-1;

      buf[p]=tmp+48;
      p++;
      pow>>=4;


    }

  buf[p]=0;    

  return 0;
  }
    
    
  
  

    


