/* Listing 3 */

#include <stdio.h>

#define TEST
#include "Listing4"

static int c;

int getLength(void);

/* target function */
int complexDecision(int a, int b)
{
  if (((a > b) && (a < getLength())) || (a == 15))
     c = a + b;
  else
     c = 0;
  return c;
}

/******** begin test code **********/
#if defined( TEST )

static int length;

struct testParameters
{
  int     a;            /* input parameter */
  int     b;            /* input parameter */
  int     length;       /* function call return */
  int     returnValue;  /* target return value */
  char    *errorMsg;  /* message if error detected */
};

#define MAX 32767       /* 16 bit integer boundary */

struct testParameters testCase[] =
{
  {  1,  0,MAX,  1,"a > b and a < length" },
  {  0,  0,MAX,  0,"a = b and a < length" },
  { -1,  0,MAX,  0,"a < b and a < length" },
  { -1, -1,MAX,  0, "a and b = -1 and a < length" },
  {MAX,  0,MAX,  0, "a > b and a = length" },
  {  0,  0,  0,  0, "a, b and length = 0" },
  { -1, -1, -1,  0, "a, b and length = -1" },
  {MAX,MAX,MAX,  0, "a, b, and length = MAX" },
  { 15, 15,MAX, 30, "a = b, a < length and a = 15" },
  {15,MAX,MAX,-32754,"a < b, a < length and a = 15" },
  {15,MAX,MAX,-32754,"a = b, a < length and a = 15" },
  { 15, 14, 14, 29, "a > b, a > length and a = 15" },
  { 15,  0, 15, 15, "a > b, a = length and a = 15" },
  { 15, -1,MAX, 14, "a > b, a < length and a = 15" },
  { 15,  1, 16, 16, "a > b, a < length and a = 15" }
};

/* function to test the complexDecision() function */
int testDecision(void)
{
  int   i;
  int   result;

  /* macro to print header and initialize error
     counter */
  StartTest("complexDecision()");

  /* loop through test cases */
  for(i = 0; i < 15; i++)
  {
     /* set dummy function return value */
     length = testCase[i].length;

     /* call the target function */
     result = complexDecision(testCase[i].a,
                              testCase[i].b);

     /* check for correct return value */
     if(result != testCase[i].returnValue)
        ErrorMsg(i, testCase[i].errorMsg);

     /* verify correct side effect */
     if(result != c)
        ErrorMsg(i, "c is incorrect");
  }

  /* macro to print results and return error count */
  EndTest;
}

main()
{
  testDecision();
}

/* dummy function */
int getLength( void )
{
  return length;
}
#endif
