/*
 *
 * INTERP.H  - the result codes/prototype for the Expression Interpreter
 *
 * Written September, 1991 by Jonathan Guthrie and placed in the public domain
 *
 */

/*
 *
 * eval() evaluates a arithmetic expression passed to it one character
 * at a time by input_function().  It continues the evaluation until it
 * doesn't recognize something, then it stops, checks to see if the
 * parenthesis match, and returns the result.  Result codes other than
 * EV_RES_OK (which signals success,) EV_BADPAREN (which signals mis-
 * matched parenthesis,) EV_OVERFLOW (which signals overflow on
 * multiplication, division, or raise-to-a-power,) or EV_DIV0 (which
 * signals attempted division by zero) indicate internal problems with
 * the evaluator.
 *
 * The result is returned in answer.  input_function is a pointer to
 * a function that returns the next character in the string to be
 * evaluated.  ("Ungetting" is handled by the evaluator, so it isn't
 * necessary that the "input function" do it.)  See the "debug" code
 * in the source for a sample input_function().
 *
 */

int     eval(double *answer, int (*input_function)(void));

/*
 *
 * These are the result codes used by the interpreter
 *
 */

#define EV_RES_OK   0
#define EV_BADTOK   1
#define EV_BADNUM   2
#define EV_BADVAL   3
#define EV_BADPOW   4
#define EV_BADFACT  5
#define EV_BADEXP   6
#define EV_BADPAREN 7
#define EV_OVERFLOW 8
#define EV_DIV0     9


char    *EV_results[10] =
{
    "",
    "A bad token was found",
    "Internal error in getnumber()",
    "Internal error in value()",
    "Internal error in power()",
    "Internal error in factor()",
    "Internal error in expression()",
    "Missing closing parenthesis",
    "Overflow in expression",
    "Division by zero error"
};
