.model large,pascal
.stack 200h

;Procedures:
public player
public dob1
public dob2
public dob3
public dob4

EXTRN  INITIALIZE:FAR            ; Initializes the modplayer for given
                                 ; sounddevice and replayrate

EXTRN  LOADMODULE:FAR            ; Loads the Module into memory

EXTRN  STARTPLAYING:FAR          ; Starts playing the module

EXTRN  STOPPLAYING:FAR           ; Stops playing the module

EXTRN  DEALLOC:FAR               ; Deallocates and erases the module
                                 ; from memory

EXTRN  ASKINIT:FAR

;Variables:

EXTRN  SOUNDDEVICE:WORD          ; The Sounddevice number

EXTRN  TIMERSPEED:WORD           ; The replayrate 1193182/Hertz

EXTRN  SBDMA:WORD                ; SoundBlaster's DMA-Channel

EXTRN  SBIRQNR:WORD              ; SoundBlaster's IRQ-Number

;Special_Variables:

EXTRN  BAR1:WORD  ; Selfdecrementing Bars, see the docs
EXTRN  BAR2:WORD  ; Selfdecrementing Bars, see the docs
EXTRN  BAR3:WORD  ; Selfdecrementing Bars, see the docs
EXTRN  BAR4:WORD  ; Selfdecrementing Bars, see the docs
EXTRN  MASTERVOLUME:Word    ; Mastervolume from 0 to 64

.data
          Error1   Db 13,10,10,7,'Module not found',13,10,'$'
          Filename db 'fanta2.mod',0  ;This is the mod to play
          Info     db 'Developed by Bob Hass, 93',0
          ;EXTRN Filename:FAR
.code

player Proc
 
       mov ah,0                    ;
       mov al,13h                  ;
       int 13h                     ; Set 320 x 200 256 Color Graphics Mode

       Mov  Ah,4Ah                 ;Reduce program memory size
       Mov  Bx,65534/16            ;Approx. size of compiled EXEFILE / 16 + 2
       Int  21h

       Mov  Ax,Seg SoundDevice
       Mov  Es,Ax                  ; Makes ES point to the player-segment
       Mov  Es:SoundDevice,6       ; Set Soundblaster = 4
       Mov  Es:TimerSpeed,58       ; The sampling rate...........
                                   ; Set 16 kHz (1193182/16000=75)
                                   ; Set 12 kHz (1193182/12000=100)
                                   ; Set 10 kHz (1193182/10000=120)
                                   ; Set 8  kHz (1193182/8000=150)
                                   ; Set 6  kHz (1193182/6000=198)
                                   ; Set TimerSpeed higher for slower machines
       mov  es:SBDMA,1
       mov  es:SBIRQNR,5
       Call Initialize             ;Initialize the SoundSystem

       mov  ax,@data
       mov  ds,ax
       Mov  Dx,offset FileName

       Call Loadmodule            ; Load the module
       Jnc  NoError

       mov ah,0
       mov al,3h
       int 10h                   ; Set Text mode

       Mov  Ah,09h
       Lea  Dx,Error1
       Int  21h                  ; Print the error-message

       Mov  Al,01111010b ; This is what was screwing up the modplayer before
       Mov  Ah,4Ch
       Int  21h                  ; Exit if error...

NoError:
       Call StartPlaying             ; Roll it !
       ;Out  21h,Al
       Mov  Ax,Seg SoundDevice
       Mov  Es,Ax                    ; Make ES Point to the PlayerSegment

WaitEsc:

       In   Al,60h
       Cmp  Al,1
       Jnz  WaitEsc              ; Wait until someone presses ESCAPE.

       Mov  Al,0                 ; Let the interrupts come again...
       Out  21h,Al

       Call StopPlaying          ; Stop the funky music

       Call DeAlloc              ; Deallocate the memory for the module

       mov ah,0
       mov al,3h
       int 10h

       Mov  Ah,4Ch
       Int  21h                  ; Exit to DOS

player EndP

dob1    proc far
        Mov  Ax,Seg SoundDevice
        Mov  Es,Ax                    ; Make ES Point to the PlayerSegment
        Mov  bx,Es:Bar1               ; Set BX to the height of bar 1
        mov  ax,bx
        ret
dob1    endp

dob2    proc far
        Mov  Ax,Seg SoundDevice
        Mov  Es,Ax                    ; Make ES Point to the PlayerSegment
        Mov  Bx,Es:Bar2               ; Set BX to the height of bar 2
        mov  ax,bx
        ret
dob2    endp
dob3    proc far
        Mov  Ax,Seg SoundDevice
        Mov  Es,Ax                    ; Make ES Point to the PlayerSegment
        Mov  bx,Es:Bar3               ; Set BX to the height of bar 3
        mov  ax,bx
        ret
dob3    endp

dob4    proc far
        Mov  Ax,Seg SoundDevice
        Mov  Es,Ax                    ; Make ES Point to the PlayerSegment
        Mov  bx,Es:Bar4               ; Set BX to the height of bar 4
        mov  ax,bx
        ret
dob4    endp
        End player

;ķ
; The Sounddevices:                                      
;ĺ
;    01  Soundplayer/Covox at LPT1  (Mono)               
;    02  Soundplayer/Covox at LPT2  (Mono)               
;    03  SoundBlaster               (Mono)               
;    04  Internal Honker            (Mono)               
;    05  Two Soundplayers LPT1+2    (Stereo)             
;    06  SoundBlaster Pro           (Stereo)             
;    07  Stereo SoundPlayer in LPT1 (Stereo)             
;    08  Stereo SoundPlayer in LPT2 (Stereo)             
;Ľ
