;   FILENAME: KEYTASK.ASM
;
;   DESCRIPTION: This file includes all the keyboard interrupt routines.
;

%tabsize 4

ifndef  MDL
    display "Error: This module requires that you provide a memory model"
    display "       definition on the command line. I.E. /dMDL=SMALL."
    err ; Force a fatal error
else

    ideal                   ; Use TASM's Ideal mode
    model   MDL,Pascal	    ; Define the memory model
	P286

include "globals.inc"  ; Public symbol declarations
include "stdlib.inc"
include "keytask.inc"

dataseg

kb              db      KB_STATE_ARRAY_SIZE dup (0)
Int09           dd      0
KbdSet		db	0	; Is the keyboard interrupt set?
Key		dw	0	; Used in program
Buttons 	dw	0	; Number of mouse buttons
MouseX		dw	0	; Mouse cursor loc and button info
MouseY		dw	0
Button		dw	0
GotMouse	dw	0
NKey		dw	0

codeseg

proc	ms_init
	mov	ax,@data
	mov	ds,ax
	mov	ax,0
	int	33h
	mov	[Word GotMouse],1
	mov	[Word Buttons],bx
	cmp	ax,0
	jne	@@PassedTest
	mov	[Word GotMouse],0	  ; No mouse present or detected
	mov	[Word Buttons],0
	ret

@@PassedTest:
	ret
endp	ms_init

proc	ms_show
	uses	ds
	mov	ax,@data
	mov	ds,ax
	mov	ax,1
	int	33h
	mov	ax,3
	int	33h
	shr	cx,3
	shr	dx,3
	mov	[Button],bx
	mov	[MouseX],cx
	mov	[MouseY],dx
	ret
endp    ms_show

proc	ms_hide
	mov	ax,2
	int	33h
	ret
endp	ms_hide

proc	Keys
	push	ds
	mov	ax,@data
	mov	ds,ax
;	 call	 K_ConvertKey
;	 mov	 [Word cs:KeyTaskKey],0FFFFh
	cmp	[Word GotMouse],1
	je	@@CheckMouse
	mov	[Word MouseX],0
	mov	[Word MouseY],0
	mov	[Word Button],0
	jmp	@@TestAfterMouse

@@CheckMouse:
	mov	ax,3			; Read mouse stuff
	int	33h
	shr	cx,3
	shr	dx,3
	mov	[Button],bx
	mov	[MouseX],cx
        mov     [MouseY],dx

@@TestAfterMouse:
	cmp	[Button],0
	je	@@DoneWithItall
	cmp	[GotMouse],1
	jne	@@DoneWithItAll
	mov	ax,5
	mov	bx,0
	int	33h

@@DoneWithItAll:
	mov	ax,[Key]
	mov	bx,[MouseY]
	mov	cx,[MouseX]
	mov	dx,[Button]
	pop	ds
	cmp	ax,0
	ret
endp    Keys

proc    sd_KbdTask near
        push    ax bx cx dx si di ds es

        mov     ax, seg KB
        mov     ds, ax
        in      al, 60h                         ;get scan code
        mov     dl, al
        and     ax, 7fh                         ;mask off upper bit of al, clear ah
        mov     bx, offset KB
        add     bx, ax                          ;ds:dx points to KBState[ scancode ]
        and     dl, 80h
        jz      @@keyDown
                                                ;key was released
        mov     [Byte bx], 0
        jmp     @@done
@@keyDown:                                      ;key was pressed
        mov     [Byte bx], 1
@@done:
        ;reset keyboard
        in      al, 61h
        or      al, 80h
        nop
        nop
        out     61h, al
        and     al, 7fh
        nop
        nop
        out     61h, al

	;tell the Programmable Interrupt Controller
	;that the interrupt has been processed
        cli
        mov     al, 20h
        out     20h, al

        pop     es ds di si dx cx bx ax
        iret
endp    sd_KbdTask

proc    SetKbdTask
	push	ds
	mov	ax,@data
	mov	ds,ax
	cmp	[Byte KbdSet],1
        jne     @@1
	pop	ds
        ret
@@1:	mov	[Byte KbdSet],1

	; Install the keyboard handler
	mov	ax,3509h
	int	21h

	mov	[Word Int09+2],es
	mov	[Word Int09],bx

	push	ds
	mov	ax,2509h
	push	cs
	pop	ds
	mov	dx,offset sd_KbdTask
	int	21h
	pop	ds

	pop	ds
        ret
endp    SetKbdTask

proc    OffKbdTask
	push	ds
	mov	ax,@data
	mov	ds,ax
	cmp	[Byte KbdSet],0
        jne     @@1
	pop	ds
	ret
@@1:	mov	[Byte KbdSet],0
	mov	ax,2509h
	mov	dx,[Word Int09]
	mov	ds,[Word Int09+2]
        int     21h
	pop	ds
	ret
endp    OffKbdTask

endif   ; ifndef MDL

end


