
;   FILENAME: MEM.ASM
;
;   DESCRIPTION:

%tabsize 4

ifndef  MDL
    display "Error: This module requires that you provide a memory model"
    display "       definition on the command line. I.E. /dMDL=SMALL."
    err ; Force a fatal error
else

    ideal                           ; Use TASM's Ideal mode
    model   Small,Pascal	      ; Define the memory model
    P286

include "stdlib.inc"

dataseg

Heap		dw	0		; Segment of 4k heap
HeapPtr 	dw	0

codeseg

proc	sl_InitHeap
	push	ds
	mov	ax,@data
	mov	ds,ax
	mov	bx,4096
	shr	bx,1
	shr	bx,1
	shr	bx,1
	shr	bx,1
	mov	ah,48h
	int	21h
	mov	[Heap],ax
	mov	[HeapPtr],0
	pop	ds
	ret
endp    sl_InitHeap

proc	sl_Allocate	Size:word,Store:dword
	uses	es,ds
	mov	ax,@data
	mov	ds,ax
	mov	bx,[Size]
	shr	bx,4
	inc	bx
	mov	ah,48h
	int	21h
	mov	es,[Heap]
	mov	di,[HeapPtr]
	stosw
	mov	[HeapPtr],di
	les	di,[Store]
	mov	[Word es:di],0
	mov	[es:di+2],ax
	ret
endp    sl_Allocate

proc    sl_FreeAllHeap
	push	es ds
	mov	ax,@data
	mov	ds,ax
	cmp	[HeapPtr],0
	je	@@FreeHeap
	mov	si,0
	mov	bx,[HeapPtr]
	mov	ds,[Heap]

@@HeapClearLoop:
	push	si
	mov	es,[si]
	mov	ah,49h
	int	21h
	pop	si
	add	si,2
	cmp	si,bx
	jne	@@HeapClearLoop

@@FreeHeap:
	pop	ds
	push	ds es
	mov	es,[Heap]
	mov	ah,49h
	int	21h
	pop	es ds es
	ret
endp	sl_FreeAllHeap

endif   ; ifndef MDL

end

