;Ŀ
;  FILENAME: PPSDET.ASM   Version 1.10 				     
;									     
;  DATE    : July 27, 1992						     
;                                                                           
;  Ideal Mode -- Turbo Assembler v2.01 and above			     
;                                                                           
;  DESCRIPTION: This file includes all routines for detecting what sound    
;		 equipment is onboard the computer.			     
;

	ideal				; Use TASM's Ideal mode.
	model	Small,Pascal		; Define the memory model.
	P286				; Set up for 286 instructions.
	jumps				; Have TASM automatically resolve out-
					; of-range jumps.

	include "pps.inc"

codeseg

;͸
; NAME       : sd_DetectSB						     
;                                                                           
; ENTRY      : None                                                         
;                                                                           
; RETURN     : None                                                         
;                                                                           
; DESCRIPTION: Soundblaster specific code.  Finds Soundblaster port	     
;		address is available.  This code is based on a lot of	     
;		technical junk that came out of the SBK around section 8-4.  
;                                                                           
;		*** Written by Joshua C. Jensen 			     
;;
proc	sd_DetectSB
	mov	dx,210h
@@TopLoop:
	add	dx,6
	mov	al,1
	out	dx,al			; Send a 1 to reset the port.
	mov	cx,10
@@WaitLoop:                             ; This should be about 3 ms
	loop	@@WaitLoop
	mov	al,0
	out	dx,al			; Send a 0 to reset the port.
	add	dx,6
	call	sd_PollSB
	jnb	@@Found
	sub	dx,0Ch
	add	dx,10h
	cmp	dx,270h
	jnz	@@TopLoop
	jmp	@@Exit
@@Found:
	mov	al,0D1h
	out	dx,al
	mov	bx,size SoundSrcStruc
        add     bx,offset SoundSources
	mov	[bx+SoundSrcStruc.AddressLeft],dx
	mov	[Byte SoundSource],1
@@Exit:
	ret
endp	sd_DetectSB

proc	sd_PollSB
        mov     bx,10
@@TopLoop:
        mov     cx,255
@@PollIt:
        in      al,dx
        rol     al,1
        jnb     @@GotAResponse
        loop    @@PollIt
        dec     bx
        jnz     @@TopLoop
        stc
@@GotAResponse:
        ret
endp    sd_PollSB

;͸
; NAME       : sd_DetectDACs						     
;                                                                           
; ENTRY      : None                                                         
;                                                                           
; RETURN     : SoundSource set to first DAC found in SoundSources list.     
;                                                                           
; DESCRIPTION: DAC specific code.  Finds the port addresses of all          
;		installed parallel ports on the system. 		     
;									     
;              *** Written by Joshua C. Jensen                              
;;
proc	sd_DetectDACs
	uses	es
	mov	ax,0040h
	mov	es,ax
	mov	si,8
	mov	bx,size SoundSrcStruc
	shl	bx,1
	add	bx,offset SoundSources
	xor	cx,cx
	xor	dx,dx			; Used for found DAC.
@@DACLoop:
	mov	ax,[es:si]		; Get the address.
	add	si,2
	or	ax,ax			; Is there a parallel port?
	jz	@@ParallelPut
	or	dx,dx			; Do we already have one here?
	jnz	@@ParallelPut
	mov	dx,cx
	add	dx,2
@@ParallelPut:
	mov	[bx+SoundSrcStruc.AddressLeft],ax
	add	bx,size SoundSrcStruc
	inc	cx
	cmp	cx,4
	jz	@@DACLoop
	mov	[SoundSource],dl
	ret
endp    sd_DetectDACs

end

