unit TimeName;
interface
uses
  ODialogs,
  OWindows,
  PlayDlg,
  PlayerId,
  Strings,
  WinDos,
  WinProcs,
  WinTypes;

type
  PTimeNameRec = ^TTimeNameRec;
  TTimeNameRec = Record
    FileName: array[0..MaxLen] of Char;
    Time: Word;
  end;

  PTimeNameDlg = ^TTimeNameDlg;
  TTimeNameDlg = Object(TDialog)
      TimeName: TTimeNameRec;
    constructor Init(AParent: PWindowsObject; AName: PChar; TN: TTimeNameRec);
    procedure Ok(var Msg: TMessage);
      virtual id_First + id_Ok;
    procedure SetUpWindow; virtual;
  end;

implementation
constructor TTimeNameDlg.Init(AParent: PWindowsObject; AName: PChar; TN: TTimeNameRec);
begin
  Inherited Init(AParent, AName);
  Move(TN, TimeName, SizeOf(TTimeNameRec));
end;

procedure AddWaveExt(Path : PChar);
var
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
begin
  FileSplit(Path,Dir,Name,Ext);
  StrCopy(Ext, '.Wav');
  StrCopy(Path, Name);
  StrCat(Path, Ext);
end;

procedure TTimeNameDlg.Ok(var Msg: TMessage);
var
  i: Integer;
begin
  SendDlgItemMessage(HWindow, ID_TNEdit, WM_GetText,
                     MaxLen, LongInt(@TimeName.FileName));
  AddWaveExt(TimeName.FileName);
  for i := 1 to 8 do
    if SendDlgItemMessage(HWindow, 5101 + i, BM_GetCheck, 0, 0) <> 0 then
      break;

  case i of
    1: TimeName.Time := 5;
    2: TimeName.Time := 10;
    3: TimeName.Time := 15;
    4: TimeName.Time := 20;
    5: TimeName.Time := 30;
    6: TimeName.Time := 40;
    7: TimeName.Time := 50;
    8: TimeName.Time := 60;
  end;

  SendMessage(Parent^.HWindow, Wm_TimeName, 0, LongInt(@TimeName));
  inherited Ok(Msg);
end;

procedure TTimeNameDlg.SetUpWindow;
begin
  inherited SetUpWindow;
  SendDlgItemMessage(HWindow, ID_TNEdit, WM_SetText, 0, LongInt(@TimeName.FileName));
  SendDlgItemMessage(HWindow, ID_TN5, BM_SetCheck, 1, 0);
end;
end.