Library WaveInfo;
{
  Copyright (c) June 1993, by Charlie Calvert
  Feel free to use this code as an adjunct to your own programs.
}

uses
  MMSystem,
  PlayInfo,
  Strings,
  WinCrt,
  WinProcs,
  WinTypes;

function GetNumTracks: LongInt; export;
Var
  Info   : TMCI_Status_Parms;
  Result : LongInt;
  Flags  : LongInt;
  S1     : array [0..MsgLen] of Char;
begin
  FillChar(Info, SizeOf(TMci_Status_Parms), 0);
  Info.dwItem     := MCI_STATUS_NUMBER_OF_TRACKS;
  Flags := MCI_STATUS_ITEM;
  Result := mciSendCommand( wDeviceId, MCI_STATUS, Flags, Longint(@Info));
  if Result <> 0 then begin
    ErrorMsg(Result, S1);
    GetNumTracks := -1;
    exit;
  end;
  GetNumTracks := Info.dwReturn;
end;

procedure PlayFromTo(Start, Finish: Byte); export;
Var
  Info          : TMCI_Play_Parms;
  Flags, Result : LongInt;
  S1: array[0..MsgLen] of Char;
begin
  Info.dwCallBack := PlayWindow;
  Info.dwFrom := 600;
  Info.dwTo   := 1000;

  Flags := MCI_FROM OR MCI_TO or Mci_Notify;
  Result := mciSendCommand(wDeviceId, MCI_PLAY, Flags, Longint(@Info));

  if Result <> 0 then ErrorMsg(Result, S1);
end;

function DoRecord(MMSecs: LongInt): LongInt; export;
var
  Info: TMCI_Record_Parms;
  Flags: Word;
  Result: LongInt;
  S1     : array [0..MsgLen] of Char;
begin
  Info.dwCallBack := PlayWindow;
  Info.dwTo := MMSecs;
  Flags := Mci_To or Mci_Notify;
  Result := MciSendCommand(wDeviceID, Mci_Record, Flags, LongInt(@Info));
  if Result <> 0 then ErrorMsg(Result, S1);
end;

function SaveFile(FileName: PChar): Boolean; export;
var
  MciSave: TMCI_SaveParms;
  Flags: Word;
  Result: LongInt;
  S1     : array [0..MsgLen] of Char;
begin
  mciSave.lpfileName := FileName;
  Flags := MCI_Save_File or Mci_Wait;
  Result := MciSendCommand(wDeviceID, MCI_Save, Flags, LongInt(@MciSave));
  if Result <> 0 then ErrorMsg(Result, S1);
end;

exports
  OpenMCI index 1,
  CloseMCI index 2,
  PlayMCI index 3,
  SetTimeFormatMS index 4,
  GetInfo index 5,
  GetNumTracks index 6,
  GetLen index 7,
  PlayFromTo index 8,
  DoRecord index 9,
  SaveFile index 10,
  GetMode index 11,
  GetLocation index 12;
begin
end.
