UNIT VTWins;

INTERFACE

USES VTGlobal, VTStrConst, StrConst,
     SoundDevices, SongUnit, SongElements, PlayMod,
     Output43, Vid43, Kbd;


TYPE
  TChWindows = ARRAY[1..4] OF TWindow;

CONST

{
  EmptyPalet        = #$07;

  ScreenPalet       = #$07#$85;
  RunInfoPalet      = #$47#$E0#$07#$F4;
  MiscInfoPalet     = #$47#$E7;
  CreditsPalet      = #$47#$C2;

  InfoNotePalet     = #$E7#$42;
  PlayBarsPalet     = #$80#$A0#$C0;

  OscilloscPalet    = #$47#$58;
  SamplesPalet      = #$07#$E0;
  Samples1Palet     = #$07#$E7#$E0#$00#$70#$E1#$54#$53;
  Samples2Palet     = #$07#$E7#$E0;
  MenusPalet        = #$07#$00#$50#$17#$E1#$01#$10;

  PartPalet         = #$A0#$00#$07;
}

  EmptyPalet        = #$01;

  ScreenPalet       = #$61#$62#$31;

  F8Palet           = #$10#$30#$10;

  RunInfoPalet      = #$51#$70#$01#$23;
  MiscInfoPalet     = #$51#$70;
  LabelPalet        = #$51#$37;

  ChannelNumPalet   = #$25;
  RunSamplePalet    = #$01;
  InfoNotePalet     = #$71#$25#$70;
  PlayBarsPalet     = #$60#$40#$30;

  OscilloscPalet    = #$31#$2E;
  SamplesPalet      = #$01#$70;
  Samples1Palet     = #$01#$71#$70#$00#$20#$75#$23#$37;
  Samples2Palet     = #$01#$71#$70;
  MenusPalet        = #$01#$00#$20#$51#$75#$05#$50;

  PartPalet         = #$40#$00#$01#$25;

  CreditsPalet      = #$51#$21#$31;


  wF8Demo      : TWindow = (x: 0; y: 0; w:80; h:27; col: F8Palet;        vis:FALSE; forz:FALSE; act:FALSE);
  wF8DemoUp    : TWindow = (x: 0; y:-1; w:80; h: 2; col: ScreenPalet;    vis:FALSE; forz:FALSE; act:FALSE);
  wF8DemoDown  : TWindow = (x: 0; y:26; w:80; h: 7; col: ScreenPalet;    vis:FALSE; forz:FALSE; act:FALSE);

  wScreen      : TWindow = (x: 0; y: 0; w:80; h:43; col: ScreenPalet;    vis:FALSE; forz:FALSE; act:FALSE);

  wTopLine     : TWindow = (x: 0; y: 0; w:80; h: 6; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wRunInfo     : TWindow = (x: 0; y: 0; w:20; h: 6; col: RunInfoPalet;   vis:FALSE; forz:FALSE; act:FALSE);
  wMiscInfo    : TWindow = (x:19; y: 0; w:46; h: 6; col: MiscInfoPalet;  vis:FALSE; forz:FALSE; act:FALSE);
  wLabel       : TWindow = (x:59; y: 0; w:21; h: 6; col: LabelPalet;     vis:FALSE; forz:FALSE; act:FALSE);

  w2ndLine     : TWindow = (x: 0; y: 5; w:80; h: 6; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wChannelNum  : TWindow = (x: 0; y: 5; w: 5; h: 6; col: ChannelNumPalet;vis:FALSE; forz:FALSE; act:FALSE);
  wRunSample   : TWindow = (x: 3; y: 5; w:27; h: 6; col: RunSamplePalet; vis:FALSE; forz:FALSE; act:FALSE);
  wInfoNote    : TWindow = (x:29; y: 5; w:30; h: 6; col: InfoNotePalet;  vis:FALSE; forz:FALSE; act:FALSE);
  wPlayBars    : TWindow = (x:58; y: 5; w:18; h: 6; col: PlayBarsPalet;  vis:FALSE; forz:FALSE; act:FALSE);
  wVoiceOnOff  : TWindow = (x:75; y: 5; w: 5; h: 6; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);


  wOscillosc   : TWindow = (x: 0; y:10; w:53; h:18; col: OscilloscPalet; vis:FALSE; forz:FALSE; act:FALSE);
  wSamples     : TWindow = (x: 0; y:10; w:53; h:18; col: SamplesPalet;   vis:FALSE; forz:FALSE; act:FALSE);
  wSamples1    : TWindow = (x: 0; y:10; w:27; h:17; col: Samples1Palet;  vis:FALSE; forz:FALSE; act:FALSE);
  wSamplesFill : TWindow = (x: 0; y:27; w:27; h: 1; col: Samples2Palet;  vis:FALSE; forz:FALSE; act:FALSE);
  wSamples2    : TWindow = (x:26; y:10; w:27; h:18; col: Samples2Palet;  vis:FALSE; forz:FALSE; act:FALSE);

  wMenus       : TWindow = (x:52; y:10; w:28; h:18; col: MenusPalet;     vis:FALSE; forz:FALSE; act:FALSE);

  wPartSmall   : TWindow = (x: 0; y:27; w:80; h:16; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wPartPastIdx : TWindow = (x: 0; y:27; w: 4; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE);
  wPartPast    : TChWindows = (
                           (x: 3; y:27; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y:27; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y:27; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y:27; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE)
                 );
  wPartActIdx  : TWindow = (x: 0; y:33; w: 4; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wPartAct     : TChWindows = (
                           (x: 3; y:33; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y:33; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y:33; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y:33; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE)
                 );
  wPartFutIdx  : TWindow = (x: 0; y:36; w: 4; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE);
  wPartFut     : TChWindows = (
                           (x: 3; y:36; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y:36; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y:36; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y:36; w:20; h: 7; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE)
                 );

  wPartBig     : TWindow = (x: 0; y: 5; w:80; h:38; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wPartPastBIdx: TWindow = (x: 0; y: 5; w: 4; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE);
  wPartPastBig : TChWindows = (
                           (x: 3; y: 5; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y: 5; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y: 5; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y: 5; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE)
                 );
  wPartActBIdx : TWindow = (x: 0; y:22; w: 4; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE);
  wPartActBig  : TChWindows = (
                           (x: 3; y:22; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y:22; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y:22; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y:22; w:20; h: 4; col: EmptyPalet;     vis:FALSE; forz:FALSE; act:FALSE)
                 );
  wPartFutBIdx : TWindow = (x: 0; y:25; w: 4; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE);
  wPartFutBig  : TChWindows = (
                           (x: 3; y:25; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:22; y:25; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:41; y:25; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE),
                           (x:60; y:25; w:20; h:18; col: PartPalet;      vis:FALSE; forz:FALSE; act:FALSE)
                 );
  wCredits     : TWindow = (x: 0; y: 5; w:80; h:38; col: CreditsPalet;   vis:FALSE; forz:FALSE; act:FALSE);

CONST
  BarVal : CHAR = '';

  FirstChannel : BYTE = 1;

VAR
  wriX1, wriX2,
  wmiX1, wmiX2, wmiX3,
  winX1, winX2, winX3, winX4, winX5,
  wsX1                               : WORD;



PROCEDURE InitWinF8Demo;
PROCEDURE InitWinScreen;
PROCEDURE InitWinTopLine;
PROCEDURE InitWin2ndLine;
PROCEDURE InitWinOscillosc;
PROCEDURE InitWinSamples;
PROCEDURE InitWinMenus;
PROCEDURE InitWinPart;
PROCEDURE InitWinBigPart;
PROCEDURE InitWinCredits;

PROCEDURE InitScreen;

PROCEDURE RefreshMiscInfo   (VAR Song: TSong);
PROCEDURE RefreshModuleInfo (VAR Song: TSong);




IMPLEMENTATION

USES Heaps;




PROCEDURE InitWinF8Demo;
  VAR
    i       : WORD;
    SaveOfs : WORD;
    Spaces  : STRING[80];
  BEGIN
    SaveOfs   := ScrOffset;
    ScrOffset := 0;

    ClearScreen;
    PutWindowBigFrame(wF8Demo);

    WITH wF8Demo DO
      BEGIN

        FillChar(Spaces, SIZEOF(Spaces), ' ');
        Spaces[0] := #80;

        FOR i := 0 TO 26 DO
          DirectWriteAttr(ParseCoords(0, i), Spaces, BYTE(Col[3]));

        PutWindowBigFrame(wF8DemoUp);
        PutWindowBigFrame(wF8DemoDown);

        DirectWriteAttr(ParseCoords(27, 4), 'Demo de ventanas  en el VT', BYTE(Col[3]));
        DirectWriteAttr(ParseCoords(35, 6), 'Te gusta?',                 BYTE(Col[3]));

        DirectWriteAttr(ParseCoords(7, 10),
          'En la prxima versin se supone que aqu podrs hacer el Shell.',                 BYTE(Col[2]));
      END;

    ScrOffset := SaveOfs;
  END;


PROCEDURE InitWinScreen;
  BEGIN
    ClearScreen;
    PutWindowBigFrame(wScreen);
  END;


PROCEDURE InitWinRunInfo;
  BEGIN
    PutWindow(wRunInfo);

    WITH wRunInfo DO BEGIN
      vis  := FALSE;
      forz := FALSE;
      act  := FALSE;

      wriX1 := 12;
      wriX2 := 16;
      DirectWrite     (ParseCoords(x+ 1, y+1), GetString(StrPosition));
      DirectWrite     (ParseCoords(x+ 1, y+2), GetString(StrPattern));
      DirectWrite     (ParseCoords(x+ 1, y+3), GetString(StrNote));
      DirectWrite     (ParseCoords(x+ 1, y+4), GetString(StrTempo));
      DirectWriteAttr (ParseCoords(x+wriX2-1, y+1), '/',   BYTE(col[3]));
      DirectWriteAttr (ParseCoords(x+wriX2-1, y+2), '/',   BYTE(col[3]));
      DirectWriteAttr (ParseCoords(x+wriX2-1, y+3), '/',   BYTE(col[3]));
      RectAttr        (ParseCoords(x+wriX2,   y+1), 3, 3,  BYTE(col[2]));
      RectAttr        (ParseCoords(x+wriX1,   y+1), 3, 4,  BYTE(col[2]));
      DirectWriteAttr (ParseCoords(x+wriX2,   y+4), 'F',   BYTE(col[3]));
      DirectWriteAttr (ParseCoords(x+wriX2+1, y+4), '  ',  BYTE(col[2]));
    END;
  END;


PROCEDURE InitWinMiscInfo;
  BEGIN
    PutWindow(wMiscInfo);

    WITH wMiscInfo DO BEGIN
      DirectWrite (ParseCoords(x+1,  y+1), GetString(StrModule));
      DirectWrite (ParseCoords(x+1,  y+2), GetString(StrFilename));
      DirectWrite (ParseCoords(x+1,  y+3), GetString(StrMemoryLeft));
      DirectWrite (ParseCoords(x+1,  y+4), GetString(StrSampleRate));
      DirectWrite (ParseCoords(x+18, y+4), GetString(StrVolume));
      wmiX1 := 12;
      wmiX2 := 25;
      wmiX3 := 26;
      DirectWrite (ParseCoords(x+wmiX2-1, y+2), '/');
      RectAttr    (ParseCoords(x+wmiX1, y+1), 20,         1, BYTE(col[2]));
      RectAttr    (ParseCoords(x+wmiX1, y+2), 12,         1, BYTE(col[2]));
      RectAttr    (ParseCoords(x+wmiX2, y+2), 12,         1, BYTE(col[2]));
      RectAttr    (ParseCoords(x+wmiX1, y+3), 21,         1, BYTE(col[2]));
      RectAttr    (ParseCoords(x+wmiX1, y+4), 5,          1, BYTE(col[2]));
      RectAttr    (ParseCoords(x+wmiX3, y+4), 3,          1, BYTE(col[2]));
    END;
  END;


PROCEDURE InitWinLabel;
  BEGIN
    PutWindow(wLabel);

    WITH wLabel DO BEGIN
      RectAttr    (ParseCoords(x+2, y+2), 17, 2, BYTE(col[2]));
      DirectWrite (ParseCoords(x+3, y+2), 'Vangeliracker');
      DirectWrite (ParseCoords(x+4, y+3), NoBetaPadding+Version+BetaPadStr);
    END;
  END;


PROCEDURE InitWinTopLine;
  BEGIN
    InitWinRunInfo;
    InitWinMiscInfo;
    InitWinLabel;
  END;


PROCEDURE InitWinChannelNum;
  CONST
    s : STRING[2] = '  ';
  VAR
    i : WORD;
  BEGIN
    PutWindow(wChannelNum);

    WITH wChannelNum DO
      FOR i := 1 TO 4 DO
        BEGIN
          s[2] := CHAR(i + ORD('0'));
          DirectWrite(ParseCoords(x+1, y+i), s);
        END;
  END;


PROCEDURE InitWinRunSample;
  BEGIN
    PutWindow(wRunSample);
  END;


PROCEDURE InitWinInfoNote;
  BEGIN
    PutWindow(wInfoNote);

    WITH wInfoNote DO BEGIN
      winX1 :=  2;
      winX2 :=  6;
      winX3 :=  9;
      winX4 := 16;
      winX5 := 23;
      PutRotulo (ParseCoords(x+ 1, y), 'freq', BYTE(col[2]));
      PutRotulo (ParseCoords(x+ 6, y), 'vl',   BYTE(col[2]));
      PutRotulo (ParseCoords(x+11, y), 'reps', BYTE(col[2]));
      PutRotulo (ParseCoords(x+18, y), 'repl', BYTE(col[2]));
      PutRotulo (ParseCoords(x+26, y), 'len',  BYTE(col[2]));
      RectAttr  (ParseCoords(x+ 2, y+1), 3, 4, BYTE(col[3]));
      RectAttr  (ParseCoords(x+ 6, y+1), 2, 4, BYTE(col[3]));
      RectAttr  (ParseCoords(x+ 9, y+1), 6, 4, BYTE(col[3]));
      RectAttr  (ParseCoords(x+16, y+1), 6, 4, BYTE(col[3]));
      RectAttr  (ParseCoords(x+23, y+1), 6, 4, BYTE(col[3]));
    END;
  END;


PROCEDURE InitWinPlayBars;
  VAR
    i, j : WORD;
  BEGIN
    PutWindow(wPlayBars);

    WITH wPlayBars DO BEGIN
      vis  := FALSE;
      forz := FALSE;
      act  := FALSE;

      FOR i := 1 TO 4 DO
        FOR j := 1 TO 16 DO
          DirectWriteAttr(ParseCoords(x+j, y+i), Barval, BYTE(col[1]));
    END;
  END;


PROCEDURE InitWinVoiceOnOff;
  BEGIN
    PutWindow(wVoiceOnOff);
  END;


PROCEDURE InitWin2ndLine;
  BEGIN
    InitWinChannelNum;
    InitWinRunSample;
    InitWinInfoNote;
    InitWinPlayBars;
    InitWinVoiceOnOff;
  END;

{

PROCEDURE InitOscilloscInfo;
  CONST
    EmptyStr : STRING[51] = '                                                   ';
    OscView  : STRING[30] = '';
    i        : WORD       = 0;
    j        : WORD       = 0;
    ofs      : WORD       = 0;
  VAR
    OscWinBuff    : ARRAY[1..16, 1..51*2] OF CHAR;
  BEGIN
    OscView := GetString(StrOscilloscView);
    WITH wOscillosc DO BEGIN
      FOR i := 1 TO 16 DO PutStr(OscWinBuff[i], EmptyStr, BYTE(col[1]));
      PutStr(OscWinBuff[1][21*2-1], OscView, BYTE(col[1]));
      FOR i := 3 TO 14 DO BEGIN
        OscWinBuff[i][4] := col[1];
        OscWinBuff[i][6] := col[1];
        OscWinBuff[i][8] := col[1];
        OscWinBuff[i][3] := ' ';
        OscWinBuff[i][5] := ' ';
        OscWinBuff[i][7] := #131;
        FOR j := 5 TO 50 DO BEGIN
          OscWinBuff[i][j*2]   := col[2];
          OscWinBuff[i][j*2-1] := #0;
        END;
      END;
      OscWinBuff[15][8] := col[1];
      OscWinBuff[15][7] := #150;
      FOR j := 5 TO 50 DO BEGIN
        OscWinBuff[15][j*2]   := col[1];
        OscWinBuff[15][j*2-1] := #148;
      END;

      Ofs := ParseCoords(x+1, y+1);
      FOR i := 1 TO 16 DO BEGIN
        Move(OscWinBuff[i], Ptr(ScrSegment, Ofs)^, SIZEOF(OscWinBuff[1]));
        INC(Ofs, ScreenBytesX);
      END;
    END;
  END;

}

PROCEDURE InitWinOscillosc;
  VAR
    i : WORD;
  BEGIN
    PutWindow(wOscillosc);

    WITH wOscillosc DO BEGIN
      DirectWrite(ParseCoords(x+21, y+1), GetString(StrOscilloscView));
      FOR i := 3 TO 14 DO
        DirectWrite(ParseCoords(x+4, y+i),  #131);
      DirectWrite  (ParseCoords(x+4, y+15), #150);
      FOR i := 5 TO 50 DO
        DirectWrite(ParseCoords(x+i, y+15), #148);
    END;
  END;


PROCEDURE InitWinSamples;
  VAR
    i : WORD;
  BEGIN
    PutWindow(wSamples);
    PutWindow(wSamples1);
    FOR i := 1 TO 4 DO
      WITH wPartPast[i] DO BEGIN
        PutRotulo(ParseCoords(x+5,                               y), GetString(StrChannel), BYTE(col[4]));
        PutRotulo(ParseCoords(x+5+Length(GetString(StrChannel)), y), CHAR(i+ORD('0')),      BYTE(col[4]));
      END;
  END;


PROCEDURE InitWinMenus;
  BEGIN
    PutWindow(wMenus);

    wsX1 := 4;

    WITH wMenus DO BEGIN
      RectAttr    (ParseCoords(x+2, y+2), 24, 3,  $00);
      DirectWrite (ParseCoords(x+2, y+1), '');
      DirectWrite (ParseCoords(x+2, y+3), '');
      DirectWrite (ParseCoords(x+2, y+5), '');
    END;


    WITH wMenus DO BEGIN
      DirectWriteAttr(ParseCoords(x+ 2, y+2), ' FILE  EDIT  PLAY  MISC ', BYTE(col[3]));
      RectAttr       (ParseCoords(x+14, y+1), 6,  1, BYTE(col[4]));
      RectAttr       (ParseCoords(x+14, y+2), 6,  1, BYTE(col[5]));
      RectAttr       (ParseCoords(x+14, y+3), 6,  1, BYTE(col[6]));

      DirectWriteAttr(ParseCoords(x+ 2, y+4), ' SAMPLES  PATTERN  SONG ', BYTE(col[3]));
      RectAttrMask   (ParseCoords(x+20, y+3), 6,  1, BYTE(col[7]), $0F);
      RectAttr       (ParseCoords(x+20, y+4), 6,  1, BYTE(col[5]));
      RectAttr       (ParseCoords(x+20, y+5), 6,  1, BYTE(col[4]));

{
      DirectWriteAttr(x+2, y+4, '   MODULE      SAMPLE   ', BYTE(col[3]));
      RectAttrMask   (x+2, y+3, 12,  1, $01, $F0);
      RectAttr       (x+2, y+4, 12,  1, $1E);
      RectAttr       (x+2, y+5, 12,  1, $71);

      DirectWriteAttr(x+2, y+4, ' SAMPLES  PATTERN  LINK ', BYTE(col[3]));
      DirectWriteAttr(x+2, y+4, ' SAMPLES  PATTERN  SONG ', BYTE(col[3]));
      DirectWriteAttr(x+2, y+4, ' NAME ',                   BYTE(col[3]));
}

      DirectWrite(ParseCoords(x+3, y+ 6), GetString(StrMenu1));
      DirectWrite(ParseCoords(x+3, y+ 7), GetString(StrMenu2));
      DirectWrite(ParseCoords(x+3, y+ 8), GetString(StrMenu3));
      DirectWrite(ParseCoords(x+3, y+ 9), GetString(StrMenu4));
      DirectWrite(ParseCoords(x+3, y+10), GetString(StrMenu5));
      DirectWrite(ParseCoords(x+3, y+11), GetString(StrMenu6));
      DirectWrite(ParseCoords(x+3, y+12), GetString(StrMenu7));
      DirectWrite(ParseCoords(x+3, y+13), GetString(StrMenu8));
      DirectWrite(ParseCoords(x+3, y+14), GetString(StrMenu9));
      DirectWrite(ParseCoords(x+3, y+15), GetString(StrMenu0));
    END;
  END;


PROCEDURE InitWinPart;
  VAR
    i : WORD;
  BEGIN
    PutWindow(wPartSmall);
    PutWindow(wPartPastIdx);
    PutWindow(wPartActIdx);
    PutWindow(wPartFutIdx);
    FOR i := 1 TO 4 DO BEGIN
      PutWindow(wPartPast[i]);
      PutWindow(wPartAct[i]);
      PutWindow(wPartFut[i]);
      WITH wPartPast[i] DO BEGIN
        PutRotulo(ParseCoords(x+5,                               y), GetString(StrChannel), BYTE(col[4]));
        PutRotulo(ParseCoords(x+5+Length(GetString(StrChannel)), y), CHAR(i+ORD('0')),      BYTE(col[4]));
      END;
    END;
  END;


PROCEDURE InitWinBigPart;
  VAR
    i : WORD;
  BEGIN
    PutWindow(wPartBig);
    PutWindow(wPartPastBIdx);
    PutWindow(wPartActBIdx);
    PutWindow(wPartFutBIdx);
    FOR i := 1 TO 4 DO BEGIN
      PutWindow(wPartPastBig[i]);
      PutWindow(wPartActBig[i]);
      PutWindow(wPartFutBig[i]);
      WITH wPartPastBig[i] DO BEGIN
        PutRotulo(ParseCoords(x+5,                               y), GetString(StrChannel), BYTE(col[4]));
        PutRotulo(ParseCoords(x+5+Length(GetString(StrChannel)), y), CHAR(i+ORD('0')),      BYTE(col[4]));
      END;
    END;
  END;


PROCEDURE InitWinCredits;
  VAR
    i : WORD;
  BEGIN
    PutWindow(wCredits);

    WITH wCredits DO BEGIN
      DirectWriteAttr(ParseCoords  (x+10, y+   2), GetString(StrCreditsTitle), BYTE(col[3]));

      i := 0;
      WHILE GetString(StrCredits + i) <> #0 DO
        BEGIN
          DirectWriteAttr(ParseCoords(x+10, y+i+ 4), GetString(StrCredits + i), BYTE(col[1]));
          INC(i);
        END;

      i := 0;
      WHILE GetString(StrDedicat + i) <> #0 DO
        BEGIN
          DirectWriteAttr(ParseCoords(x+10, y+i+34), GetString(StrDedicat + i), BYTE(col[2]));
          INC(i);
        END;
    END;

  END;




PROCEDURE InitScreen;
  VAR
    i, j : WORD;
    s    : STRING;
  BEGIN

    InitWinScreen;
    InitWinTopLine;
    InitWin2ndLine;
    InitWinSamples;
    InitWinMenus;
    InitWinPart;

  END;



PROCEDURE RefreshMiscInfo(VAR Song: TSong);
  VAR
    s : STRING;
    t : STRING;
    u : STRING;
  BEGIN
    WITH wMiscInfo DO BEGIN
      DirectWriteAttr(ParseCoords(x+wmiX1, y+1), Song.GetName,               BYTE(col[2]));
      DirectWriteAttr(ParseCoords(x+wmiX1, y+2), Song.FileName+Song.FileExt, BYTE(col[2]));
      DirectWriteAttr(ParseCoords(x+wmiX2, y+2), Song.GetInsidePath,         BYTE(col[2]));
      STR(Heap.HMaxAvail,    s);
      STR(Heap.HMemAvail,    t);
      STR(UmbHeap.HMemAvail, u);
                                                 {xxxxx (xxxxx) | xxxxxx}
      DirectWriteAttr(ParseCoords(x+wmiX1, y+3), '                      ', BYTE(col[2]));
      DirectWriteAttr(ParseCoords(x+wmiX1, y+3), t+' ('+s+') | '+u,        BYTE(col[2]));

      IF SoundHz >= 500 THEN
        STR(SoundHz + 50 - ((SoundHz + 50) MOD 100), s)
      ELSE
        s := 'FallB';
      DirectWriteAttr(ParseCoords(x+wmiX1, y+4), '     ',                  BYTE(col[2]));
      DirectWriteAttr(ParseCoords(x+wmiX1, y+4), s,                        BYTE(col[2]));

      STR(UserVols[1] : 3, s);
      DirectWriteAttr(ParseCoords(x+wmiX3, y+4), s,                        BYTE(col[2]));
    END;
  END;




PROCEDURE InitSampleWin(VAR Song: TSong);
  CONST
    s     : STRING      = '';
    i     : WORD        = 0;
    Instr : PInstrument = NIL;
  BEGIN
    WITH wSamples1 DO
      FOR i := 1 TO 15 DO BEGIN
        STR(i : 2, s);
        DirectWriteAttr   (ParseCoords(x+1,    y+i), s,                      BYTE(col[3]));
        Instr := Song.GetInstrument(i);
        IF Instr = NIL THEN
          DirectWriteAttr (ParseCoords(x+wsX1, y+i), '                    ', BYTE(col[2]))
        ELSE IF Instr^.Instr = NIL THEN
          DirectWriteAttr (ParseCoords(x+wsX1, y+i), Instr^.GetName,         BYTE(col[2]))
        ELSE
          DirectWriteAttr (ParseCoords(x+wsX1, y+i), Instr^.GetName,         BYTE(col[3]));
      END;

    WITH wSamples2 DO
      FOR i := 16 TO 31 DO BEGIN
        STR(i : 2, s);
        DirectWriteAttr   (ParseCoords(x+1,    y+i-15), s,                      BYTE(col[3]));
        Instr := Song.GetInstrument(i);
        IF Instr = NIL THEN
          DirectWriteAttr (ParseCoords(x+wsX1, y+i-15), '                    ', BYTE(col[2]))
        ELSE IF Instr^.Instr = NIL THEN
          DirectWriteAttr (ParseCoords(x+wsX1, y+i-15), Instr^.GetName,         BYTE(col[1]))
        ELSE
          DirectWriteAttr (ParseCoords(x+wsX1, y+i-15), Instr^.GetName,         BYTE(col[3]));
      END;
  END;




PROCEDURE RefreshModuleInfo(VAR Song: TSong);
  VAR
    s : STRING;
    i : WORD;
  BEGIN

    WITH wRunInfo DO BEGIN
      STR(Song.SequenceLength   : 3, s); DirectWrite(ParseCoords(x+wriX2, y+1), s);
      STR(Song.Patterns.Count   : 3, s); DirectWrite(ParseCoords(x+wriX2, y+2), s);
      s := '   ';
      DirectWrite(ParseCoords(x+wriX1, y+1), s);
      DirectWrite(ParseCoords(x+wriX1, y+2), s);
      DirectWrite(ParseCoords(x+wriX1, y+3), s);
      DirectWrite(ParseCoords(x+wriX1, y+4), s);
    END;

    RefreshMiscInfo(Song);

    InitSampleWin(Song);
  END;







{
VAR
  BIOSScrOffset : WORD ABSOLUTE 0:$44E;
}
BEGIN

  pwAttr    := BYTE(wScreen.col[2]);
{  ScrOffset := BIOSScrOffset;}

END.
