/* testd - Test adpcm decoder */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

struct adpcm_state {
    short      valprev_l;        /* Previous output value */
    char       index_l;          /* Index into stepsize table */
    short      valprev_r;        /* Previous output value */
    char       index_r;          /* Index into stepsize table */
};

struct adpcm_state state;

void adpcm_coder (short [], char [], int, struct adpcm_state *);
void adpcm_decoder (char [], short [], int, struct adpcm_state *);

#define NSAMPLES 20000

char   abuf[NSAMPLES/2];
short  sbuf[NSAMPLES];

main() {
    FILE    *f, *f2;
    char    fname[64],fname2[64];
    int     n;

    printf("ADPCM 4:1 stereo decoder v1.0 by Patrick Aalto 1993\r\n");
    if (_argc < 3 )
    {
        printf("Usage: %s infile outfile\r\n", _argv[0]);
        exit(1);
    }
    strcpy(fname,_argv[1]);
    strcpy(fname2,_argv[2]);

    if ( NULL == (f2=fopen(fname2,"wb")) )
    {
        printf("Error opening '%s', terminating..\r\n", fname2);
        exit(4);
    }
    if ( NULL == (f=fopen(fname,"rb")) )
    {
        printf("Error opening '%s', terminating..\r\n", fname);
        exit(4);
    }
    printf("Decoding '%s' into '%s', please wait...\r\n", fname, fname2);
    while( n = fread(&abuf,1,sizeof(abuf),f) )
    {
	adpcm_decoder(abuf, sbuf, n, &state);
	fwrite(&sbuf,4,n,f2);
    }
    fclose(f);
    fclose(f2);
    exit(0);
}
