//  Sound.h
//
//  C++ class to play digitized sounds through
//  the PC speaker.  This is a C++ wrapper for
//  John Ratcliff's routines presented in the
//  March 1993 issue of Dr. Dobbs Journal.
//
//  Kevin Dahlhausen        ap096@po.cwru.edu
//
//  Note:  Compile only in large memory model (for now.)

#ifndef Sound_h
#define Sound_h

class Sound {

    public:
        Sound(char *SoundFile, int Frequency);
        ~Sound();
        void play();                // play sound
        static int driverLoaded();  // non-zero if sound driver is loaded
        int  isPlaying();           // non-zero if ANY sound is playing
        void stop();                // stops ANY sound from playing
        int  error();               // returns:
                                    // 0 if no error
                                    // 1 if file not found
                                    // 2 if complete file could not be loaded
                                    //   (the partial file can still be played)
    private:
        struct SndStruc_s {
            unsigned char far *data;    // far address of audio data
            unsigned int SndLen;        // length of audio sample
            int far *IsPlaying;         // address of play status flag
            int freq;                   // playback frequency
            long s, e, l;
            struct SndStruc_s *next;
        };
        typedef SndStruc_s SndStruc;
        SndStruc SndInfo;
        int ErrorStat;
        void loadData(char *SoundFile);
        void massageData();
};

#endif