#ifndef SBIO_H
#define SBIO_H

extern UWORD sb_port;

/*
	Define some important SB i/o ports:
*/

#define MIXER_ADDRESS 		(sb_port+0x4)
#define MIXER_DATA			(sb_port+0x5)
#define DSP_RESET			(sb_port+0x6)
#define DSP_READ_DATA		(sb_port+0xa)
#define DSP_WRITE_DATA		(sb_port+0xc)
#define DSP_WRITE_STATUS	(sb_port+0xc)
#define DSP_DATA_AVAIL		(sb_port+0xe)

BOOL	SB_WriteDSP(UBYTE data);
UWORD	SB_ReadDSP(void);

BOOL	SB_Ping(void);

UWORD	SB_GetDSPVersion(void);
void	SB_SpeakerOn(void);
void	SB_SpeakerOff(void);
void	SB_MixerStereo(void);
void	SB_MixerMono(void);
void	SB_ResetDSP(void);

#endif
