#ifndef MDRIVER_H
#define MDRIVER_H

#include <stdio.h>
#include "mtypes.h"

#define DMODE_STEREO    1
#define DMODE_16BITS    2

typedef struct GHOLD{
	UBYTE kick;                             // =1 -> sample has to be restarted
	UBYTE active;                   // =1 -> sample is playing
	UWORD flags;                    // 16/8 bits looping/one-shot
	WORD  handle;                   // identifies the sample
	ULONG start;                    // start index
	ULONG size;                             // samplesize
	ULONG reppos;                   // loop start
	ULONG repend;                   // loop end
	ULONG frq;                              // current frequency
	UBYTE vol;                              // current volume
	UBYTE pan;                              // current panning position

	UWORD iter;                             // iteration variabele
	ULONG current;                  // current index in the sample
	ULONG increment;                // fixed-point increment value
	void *lvoltab;              // left volume table
	void *rvoltab;              // right volume table
} GHOLD;

typedef struct DRIVER{
	struct DRIVER *next;
	char    *Name;
	char    *Version;
	BOOL    (*IsPresent)            (void);
	WORD    (*SampleLoad)           (FILE *fp,ULONG size,ULONG reppos,ULONG repend,UWORD flags);
	void    (*SampleUnLoad)         (WORD handle);
	BOOL    (*Init)                 (void);
	void    (*Exit)                 (void);
	void    (*PlayStart)            (void);
	void    (*PlayStop)             (void);
	void    (*Update)                               (void);
} DRIVER;

extern DRIVER *md_driver;
extern UWORD md_device;
extern UWORD md_mixfreq;
extern UWORD md_dmabufsize;
extern UWORD md_mode;
extern UBYTE md_numchn;

extern GHOLD ghld[32];

#ifdef __cplusplus
extern "C" {
#endif

void MD_InfoDriver(void);
void MD_RegisterDriver(DRIVER *drv);
WORD MD_SampleLoad(FILE *fp,ULONG size,ULONG reppos,ULONG repend,UWORD flags);
void MD_SampleUnLoad(WORD handle);
BOOL MD_Init(void);
void MD_Exit(void);
void MD_PlayStart(void);
void MD_PlayStop(void);
void MD_Update(void);
void MD_VoiceSetVolume(UBYTE voice,UBYTE ivol);
void MD_VoiceSetFrequency(UBYTE voice,ULONG frq);
void MD_VoiceSetPanning(UBYTE voice,ULONG pan);
void MD_VoicePlay(UBYTE voice,WORD handle,ULONG start,ULONG size,ULONG reppos,ULONG repend,UWORD flags);

void SL_Init(FILE *fp,UWORD infmt,UWORD outfmt);
void SL_Load(void *buffer,ULONG length);

#ifdef __cplusplus
}
#endif

#endif
