#ifndef MLOADER_H
#define MLOADER_H

#include <stdio.h>
#include "mtypes.h"



typedef struct LOADER{
	struct LOADER *next;
	char	*type;
	char 	*version;
	BOOL    (*Init)(void);
	BOOL	(*Test)(void);
	BOOL	(*Load)(void);
	void	(*Cleanup)(void);
} LOADER;

extern UNIMOD of;
extern FILE *modfp;

extern UWORD finetune[16];


// Function prototypes:

#ifdef __cplusplus
extern "C" {
#endif

void ML_InfoLoader(void);
void ML_RegisterLoader(LOADER *ldr);

UNIMOD	*ML_LoadFP(FILE *fp);
UNIMOD	*ML_LoadFN(char *filename);
void 	ML_Free(UNIMOD *mf);
BOOL 	InitTracks(void);
void 	AddTrack(UBYTE *tr);
BOOL 	ReadComment(UWORD len);
BOOL 	AllocPatterns(void);
BOOL 	AllocTracks(void);

BOOL 	AllocInstruments(void);
BOOL 	AllocSamples(INSTRUMENT *i);

char 	*DupStr(UBYTE *s,UWORD len);
void 	*MyMalloc(size_t size);
void 	*MyCalloc(size_t nitems,size_t size);

#ifdef __cplusplus
}
#endif


#endif
