#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>

#include "mtypes.h"

#include "mdriver.h"    // -> MD_Init,MD_Exit etc.
#include "mwav.h"               // -> MW_LoadWavFN & MW_FreeWav
#include "mems.h"               // -> EMS_Init
#include "vtimer.h"


/*
	Declare external drivers:
*/

extern DRIVER gusdriver,sbdriver;


WORD vtimer;



int breakhandler(void)
{
	return 1;
}



void tickhandler(void)
{
	MD_Update();
}


void InitWasOkay(void)
{
	int t;
	SAMPLE *s1,*s2;

	if((s1=MW_LoadWavFN("b1.wav"))==NULL){
		printf("Wavload error: %s.\n",myerr);
		return;
	}

	if((s2=MW_LoadWavFN("b2.wav"))==NULL){
		printf("Wavload error: %s.\n",myerr);
		MW_FreeWav(s1);
		return;
	}

	md_numchn=4;

	VT_Init();
	atexit(VT_Exit);

	vtimer=VT_Alloc();
	VT_SetHandler(vtimer,tickhandler);
	VT_SetBPM(vtimer,125);

	MD_PlayStart();

	puts("Press key 1,2,3,4 to play the wav files, press 'q' to quit.");

	VT_Start(vtimer);

	while(1){

		t=getch();

		if(t=='q') break;

		if(t=='1'){
			MD_VoiceSetVolume(0,64);
			MD_VoiceSetPanning(0,0);
			MD_VoiceSetFrequency(0,12000);
			MD_VoicePlay(0,s1->handle,0,s1->length,0,0,s1->flags);
		}

		if(t=='2'){
			MD_VoiceSetVolume(1,64);
			MD_VoiceSetPanning(1,64);
			MD_VoiceSetFrequency(1,13000);
			MD_VoicePlay(1,s1->handle,0,s1->length,0,0,s1->flags);
		}

		if(t=='3'){
			MD_VoiceSetVolume(2,64);
			MD_VoiceSetPanning(2,128);
			MD_VoiceSetFrequency(2,10000);
			MD_VoicePlay(2,s2->handle,0,s2->length,0,0,s2->flags);
		}

		if(t=='4'){
			MD_VoiceSetVolume(3,64);
			MD_VoiceSetPanning(3,200);
			MD_VoiceSetFrequency(3,12000);
			MD_VoicePlay(3,s2->handle,0,s2->length,0,0,s2->flags);
		}
	}

	VT_Stop(vtimer);
	MD_PlayStop();
	MW_FreeWav(s1);
	MW_FreeWav(s2);
}


int main(int argc,char *argv[])
{
	puts(mikbanner);

	/*
		Initialize soundcard parameters.. you _have_ to do this
		before calling MD_Init(), and it's illegal to change them
		after you've called MD_Init()
	*/

	md_mixfreq              =44100;                         // standard mixing freq
	md_dmabufsize   =4000;                          // standard dma buf size
	md_mode                 =DMODE_16BITS|DMODE_STEREO;             // standard mixing mode
	md_device               =0;                                     // standard device: autodetect

	/*
		Register the drivers we want to use:
	*/

	MD_RegisterDriver(&sbdriver);
	MD_RegisterDriver(&gusdriver);

	/*
		disable control-break by
		installing a custom handler
	*/

#ifdef __BORLANDC__
	ctrlbrk(breakhandler);
	EMS_Init();
#endif

	//      initialize soundcard

	if(!MD_Init()){
		printf("Driver error: %s.\n",myerr);
		return 0;
	}

	printf("Using %s for %d bit %s sound at %u Hz\n\n",
			md_driver->Name,
			(md_mode&DMODE_16BITS) ? 16:8,
			(md_mode&DMODE_STEREO) ? "stereo":"mono",
			md_mixfreq);

	// call main program

	InitWasOkay();

	// and clean up

	MD_Exit();
	return 0;
}

