.386p

	NAME    resample
	EXTRN   _rvolsel :WORD
	EXTRN   _lvolsel :WORD
	EXTRN   _destsel :WORD
	EXTRN   _amplsel :WORD

	.model small,c

DGROUP  GROUP   _DATA

_TEXT   SEGMENT BYTE PUBLIC USE32 'CODE'
		ASSUME  CS:_TEXT ,DS:DGROUP,SS:DGROUP


	PUBLIC  _VC_ResampleMixMono
	PUBLIC  _VC_ResampleMixStereo
	PUBLIC  _VC_Sample16To8Copy
	PUBLIC  _VC_Sample16To16Copy
	PUBLIC  _VC_MemSet

SampleMono MACRO
	movzx eax,byte ptr [esi]        ; sample ophalen
	add eax,eax                     ; *2
	mov ax,word ptr fs:[eax]        ; volume-scalen
	add es:[di],ax                  ; en naar destbuffer zetten
	add edi,ebx                     ; dest ptr ophogen
	adc esi,edx                     ; src ptr ophogen
	ENDM


SampleStereo MACRO
	movzx eax,byte ptr [esi]        ; sample ophalen
	add eax,eax                     ; *2
	mov cx,word ptr gs:[eax]        ; rechter volume scalen
	mov ax,word ptr fs:[eax]        ; linker volume scalen
	add es:[di],ax                  ; en naar destbuffer zetten
	add es:2[di],cx                 ;
	add edi,ebx                     ; dest ptr ophogen
	adc esi,edx                     ; src ptr ophogen
	ENDM


S16To8 MACRO
	movzx eax,word ptr [esi]                        ; get sample
	add eax,eax
	mov ax,es:[eax]                               ; amplify to 8 bits sample
	mov [edi],ah                                    ; store sample
	add esi,2                                               ; update pointers
	inc edi                                                 ;
	ENDM


S16To16 MACRO
	movzx eax,word ptr [esi]
	add eax,eax
	mov ax,es:[eax]                               ; amplify to 16 bits sample
	mov [edi],ax                                    ; store sample
	add esi,2                                               ; update pointers
	add edi,2
	ENDM


repeat8 MACRO func
	func
	func
	func
	func
	func
	func
	func
	func
	ENDM

repeatf MACRO func,count
	IF count gt 8
		repeat8 func
		repeatf func,count-8
	ELSEIF count gt 0
		func
		repeatf func,count-1
	ENDIF
	ENDM


MyLoop MACRO function,unfolds,counter
	LOCAL entr,lplb
	jmp entr
lplb:
	repeatf function,unfolds
entr:
	dec counter
	jns lplb
	ENDM


_VC_ResampleMixMono proc USES ebx ecx edx esi edi fs es,
	srce: dword,
	todo: word,
	incr: dword,
	itrr: dword

	mov esi,srce                    ; esi source
	mov ax,_lvolsel
	mov fs,ax                       ; voltab selector naar fs
	mov ax,_destsel
	mov es,ax

	mov edi,itrr
	movzx edi,word ptr [edi]        ; edi is iter
	ror edi,16                                              ; low word edi=0 high=iter

	mov ebx,incr                    ; ebx is increment
	ror ebx,16                                              ;
	movzx edx,bx                    ; low word edx=always
	mov bx,2                                                ; low word ebx=2 high=frac

	push esi

	movzx ecx,todo                  ; ecx is aantal te doen
	shr ecx,5                       ; delen door 32
	MyLoop SampleMono,32,ecx

	movzx ecx,todo
	and ecx,1fh
	MyLoop SampleMono,1,ecx

	mov ebx,itrr                             ; ebx is itrr pointer
	ror edi,16
	mov word ptr [ebx],di           ; itrr aanpassen

	pop eax
	sub eax,esi
	neg eax
	ret
_VC_ResampleMixMono endp


_VC_ResampleMixStereo proc USES ebx ecx edx esi edi fs gs es,
	srce: dword,
	todo: word,
	incr: dword,
	itrr: dword

	LOCAL todo32: word,todo1: word

	mov esi,srce                    ; esi source
	mov ax,_lvolsel
	mov fs,ax                       ; voltab selector naar fs
	mov ax,_rvolsel
	mov gs,ax
	mov ax,_destsel
	mov es,ax

	mov edi,itrr
	movzx edi,word ptr [edi]        ; edi is iter
	ror edi,16                                              ; low word edi=0 high=iter

	mov ebx,incr                    ; ebx is increment
	ror ebx,16                                              ;
	movzx edx,bx                    ; low word edx=always
	mov bx,4                                                ; low word ebx=4 high=frac

	mov cx,todo
	shr cx,5
	mov todo32,cx

	mov cx,todo
	and cx,1fh
	mov todo1,cx

	push esi

	MyLoop SampleStereo,32,todo32
	MyLoop SampleStereo,1,todo1

	mov ebx,itrr                             ; ebx is itrr pointer
	ror edi,16
	mov word ptr [ebx],di           ; itrr aanpassen

	pop eax
	sub eax,esi
	neg eax
	ret
_VC_ResampleMixStereo endp



_VC_Sample16To8Copy proc USES eax ecx esi edi es,
	srce: dword,
	dest: dword,
	todo: word

	mov esi,srce                    ; esi source
	mov edi,dest

	mov ax,_amplsel
	mov es,ax                       ; voltab selector naar es

	mov cx,todo
	shr cx,5

	xor eax,eax

	MyLoop S16To8,32,cx

	mov cx,todo
	and cx,1fh

	MyLoop S16To8,1,cx
	ret
_VC_Sample16To8Copy endp



_VC_Sample16To16Copy proc USES eax ecx esi edi es,
	srce: dword,
	dest: dword,
	todo: word

	mov esi,srce                    ; esi source
	mov edi,dest

	mov ax,_amplsel
	mov es,ax                       ; voltab selector naar es

	mov cx,todo
	shr cx,5

	xor eax,eax

	MyLoop S16To16,32,cx

	mov cx,todo
	and cx,1fh

	MyLoop S16To16,1,cx
	ret
_VC_Sample16To16Copy endp


_VC_MemSet proc USES ax edi ecx es,
	dest: dword,
	dval: word,
	todo: dword

	mov ax,ds
	mov es,ax
	mov edi,dest
	mov ax,dval
	mov ecx,todo
	cld
	rep stosw
	ret
_VC_MemSet endp

_TEXT   ENDS

_DATA   SEGMENT DWORD PUBLIC USE32 'DATA'
_DATA   ENDS

		END
