unit PlayDlg;
{
  Copyright (c) June 1993, by Charlie Calvert
  Feel free to use this code as an adjunct to your own programs.
}

interface
uses
  CommDlg, MMSystem, Strings, Objects, ODialogs,
  OWindows, PlayerID, WinDos, WinProcs, WinTypes;

const
  DDL_READWRITE = $0000;
  DDL_READONLY  = $0001;
  DDL_HIDDEN    = $0002;
  DDL_SYSTEM    = $0004;
  DDL_DIRECTORY = $0010;
  DDL_ARCHIVE   = $0020;
  DDL_POSTMSGS  = $2000;
  DDL_DRIVES    = $4000;
  DDL_EXCLUSIVE = $8000;

  PlayTimer = 1;
  MidiError = - 251;
  MaxLen = 150;
  MinLen = 50;
  MaxSize = 150;

type
  PPlayDialog = ^TPlayDialog;
  TPlayDialog = Object(TDialog)
      WildCard,
      CurrentDirectory,
      FileTitle: array[0..MaxLen] of Char;
      BlueBrush,
      Pattern: HBrush;
      Mode: LongInt;
      DevStatus: PChar;
    constructor Init(AParent: PWindowsObject; AName: PChar);
    destructor Done; virtual;
    procedure SetUpWindow; virtual;
    procedure ReportStatus; virtual;
    procedure GetStatus; virtual;
    procedure StartTimer;
    procedure StopNow; virtual;
    procedure FileFill(var Msg: TMessage);
      virtual id_First + id_FileFill;
    procedure WMControlColor(var Msg: TMessage);
      virtual wm_First + wm_CtlColor;
  end;

implementation

constructor TPlayDialog.Init(AParent: PWindowsObject; AName: PChar);
begin
  inherited Init(AParent, AName);
  GetMem(DevStatus, MinLen);
end;

destructor TPlayDialog.Done;
begin
  if BlueBrush <> 0 then DeleteObject(Pattern);
  FreeMem(DevStatus, MinLen);
  KillTimer(HWindow, PlayTimer);
  inherited Done;
end;

procedure TPlayDialog.SetUpWindow;
begin
  inherited SetUpWindow;
  Pattern := GetStockObject(Gray_Brush);
  BlueBrush := CreateSolidBrush(RGB(0, 0, 64));
end;

procedure TPlayDialog.StopNow;
begin
  KillTimer(HWindow, PlayTimer);
end;

procedure SplitDirName(Path : PChar; Dir: PChar; WName: PChar);
var
  Name: NameStr;
  Ext: ExtStr;
begin
  FileSplit(Path,Dir,Name,Ext);
  Dir[StrLen(Dir) - 1] := #0;
  StrCopy(WName, Name);
  StrCat(WName, Ext);
end;

procedure TPlayDialog.FileFill;
Const
  szDefExt = 'Sd';
  FileNameMax = 100;
var
  OpenFN: TOpenFileName;
  FileTitle2: PChar;
  WinDir: array[0..145] of Char;

begin
  GetMem(FileTitle2, MaxSize);
  StrCopy(FileTitle2, WildCard);
  FillChar(OpenFN, SizeOf(TOpenFileName), #0);
  with OpenFN do begin
    hInstance       := HInstance;
    hwndOwner       := HWindow;
    lpstrDefExt     := szDefExt;
    lpstrFile       := FileTitle2;
    lpstrInitialDir := 'c:\windows';
    lpstrFilter     := 'Server Demo';
    lpstrFileTitle  := FileTitle;
    lStructSize     := sizeof(TOPENFILENAME);
    nFilterIndex    := 1;
    nMaxFile        := FilenameMax;
  end;
  if GetOpenFileName(OpenFN) then begin
    SplitDirName(FileTitle2, CurrentDirectory, FileTitle);
    SendMessage(HWindow, WM_FILLDIR, 0, 0);
  end;
  FreeMem(FileTitle2, MaxSize);
end;

procedure TPlayDialog.GetStatus;
begin
  case Mode of
    Mci_Mode_Not_Ready: StrCopy(DevStatus, 'Not Ready');
    Mci_Mode_Pause: StrCopy(DevStatus, 'Pause');
    Mci_Mode_Play: StrCopy(DevStatus, 'Play');
    Mci_Mode_Stop: StrCopy(DevStatus, 'Stop');
    Mci_Mode_Open: StrCopy(DevStatus, 'Open');
    Mci_Mode_Record: StrCopy(DevStatus, 'Recording');
    Mci_Mode_Seek: StrCopy(DevStatus, 'Seeking');
  else begin
    Mode := MidiError;
    StrCopy(DevStatus, 'Error?');
  end;
  end;
  SendDlgItemMessage(HWindow, 125, WM_SETTEXT, 0, LongInt(DevStatus));
end;

procedure TPlayDialog.ReportStatus;
begin
  Abstract;
end;

procedure TPlayDialog.StartTimer;
begin
  if (SetTimer(HWindow, PlayTimer, 1000, nil) = 0) then
    MessageBox(HWindow, 'No Timers!', 'Whoops!', mb_Ok + mb_IconExclamation);
end;

procedure TPlayDialog.WMControlColor(var Msg: TMessage);
begin
  case Msg.LParamHi of
    ctlColor_Static, ctlcolor_ListBox, ctlColor_Edit, ctlColor_Btn:
      begin
        SetTextColor(Msg.WParam, Rgb(255, 255, 0));
        SetBkMode(Msg.WParam, Transparent);
        Msg.Result := BlueBrush;
      end;
    ctlcolor_Dlg:
      begin
        SetBkMode(Msg.WParam, Transparent);
	Msg.Result := Pattern;
      end;
  else
    DefWndProc(Msg);
  end;
end;
end.