/*
// SEFX.H
//
// Header file for the Sefx sound effects library
//
// Copyright (c) 1992 Bri Productions
//
*/


#if defined  __TURBOC__
#if  __STDC__
#define  _Cdecl
#else
#define  _Cdecl  cdecl
#endif
#elif defined  __ZTC__
#define  _Cdecl
#elif defined  M_I86 && !defined  __ZTC__
#if !defined NO_EXT_KEYS
#define  _Cdecl  cdecl
#else
#define  _Cdecl
#endif
#endif


/*
//-------------------------------------
//
// SndOpen() return codes
//
//-------------------------------------
*/

#define  NOERR       0           /* no error                */
#define  OPENED      1           /* sefx already opened     */
#define  MALLOC_ERR  4           /* memory allocation error */



/*
//-------------------------------------
//
// time bases
//
//-------------------------------------
*/

#define  LOW      3              /* 54.9 milliseconds */
#define  MED      2              /* 27.5 milliseconds */
#define  HIGH     1              /* 13.7 milliseconds */
#define  ULTRA    0              /*  6.9 milliseconds */


/*
//-------------------------------------
//
// on and off
//
//-------------------------------------
*/

#define ON        1
#define OFF       0


/*
//-------------------------------------
//
// TONE typedef
//
//-------------------------------------
*/

typedef struct{
            int freq;
            int durtn;
            }TONE;



/*
//-------------------------------------
//
// function macros
//
//-------------------------------------
*/

#define  SndPause(a)          SndTone(0, a)
#define  SndPulse(a,b,c,d) SndTrill(a,0,b,c,d)



/*
//-------------------------------------
//
// function prototypes
//
//-------------------------------------
*/

int      _Cdecl   SndOpen     (unsigned Qsize, int tbase);
void     _Cdecl   SndClose    (void);

unsigned _Cdecl   SndLen      (void);

int      _Cdecl   SndTbase    (int tbase);
void     _Cdecl   SndFlush    (void);
int      _Cdecl   SndHold     (int on_off);
void     _Cdecl   SndTerm     (void);

void     _Cdecl   SndTone     (int freq, int durtn);
void     _Cdecl   SndSlide    (int start, signed dfreq, int durtn, int reps);
void     _Cdecl   SndTrill    (int freq1, int freq2, int durtn1, int durtn2, int reps);
void     _Cdecl   SndString   (const TONE *str, int n_tone, int reps);

int      _Cdecl   SndMs       (unsigned ms);

