{Convert PianoMan tunes (*.MUZ files) to interrupt music format}

program PManCvt;

type
  FiledNote = RECORD			{format of PianoMan note records}
                O,NS:  BYTE;
                D:  WORD;
              end;

const
  NoteName:  array[0..15] of STRING[2] = (	{note number to name conv.}
  '00','CN','CS','DN','DS','EN','FN','FS',
  'GN','GS','AN','AS','BN','00','00','00' );

var
  filenm:  STRING;			{name of input file}
  fp1:  FILE of FiledNote;		{input file}
  fp2:  TEXT;				{output file}
  Note:  FiledNote;			{current note record}
  ArraySize,				{size of source file}
  DurDiv,				{note duration divisor}
  i:  WORD;

begin
  WriteLn('PianoMan .MUZ file to SoundPas data array converter');
  WriteLn;
  Write('Enter name of file to convert:  ');
  ReadLn(filenm);				{get input file name}
  Write('Enter duration divisor:  ');
  ReadLn(DurDiv);
  Assign(fp1,filenm);				{open PianoMan file}
  Reset(fp1);
  ArraySize := FileSize(fp1);			{set size of data array}
  Assign(fp2,'pman.dat');
  ReWrite(fp2);					{open output file}
  Seek(fp1,9);					{skip file header}
  WriteLn(fp2,'pman:  array[1..',(ArraySize-9)*2+1,'] of BYTE = (');
  for i := 9 to ArraySize - 1 do begin		{now convert each record}
    Read(fp1,Note);
    if Note.NS and $F0 = 13*16 then		{if rest...}
      Write(fp2,Note.D div DurDiv,',000,')
    else					{else, if note...}
      Write(fp2,Note.D div DurDiv,',',NoteName[Note.NS shr 4],Note.O,',');
    if i mod 8 = 0 then WriteLn(fp2);		{include newlines}
  end;
  WriteLn(fp2,'0 );');				{end the array}
  Close(fp1);
  Close(fp2);
end.
