{ Sound Effects

Written by:

    Nels Anderson
   92 Bishop Drive
Framingham, MA  01701

Released to the public domain
}

{
Modified by:

    Stephane Cote
    660 Labarre
    Hebertville, Quebec, Canada
    G0W 1S0
}

unit SoundEff;

interface

Uses
  Crt;

procedure SndEff(Info:  POINTER);

Const
  Bat: array[1..5] of INTEGER = (
  12000,-100,6,106,0);
  BirdCall: array[1..13] of INTEGER = (
  3500,0,50,1,
  3000,0,50,1,
  4000,0,50,1,0);
  ClockTick: array[1..9] of INTEGER = (
  12500,0,19,1,
  -1,0,1000,1,0); {uses frequency of -1 for silence}
  Conveyor: array[1..5] of INTEGER = (
  37,1,3,64,0);
  Crickets: array[1..13] of INTEGER = (
  1800,0,3,10,
  2000,0,1,1,
  -1,0,100,1,0);
  DoorBuzzer: array[1..5] of INTEGER = (
  5700,1500,1,7,0);
  Explosion: array[1..5] of INTEGER = (
  300,150,6,10,0);
  PhoneRing: array[1..9] of INTEGER = (
  523,0,28,1,
  659,0,28,1,0);
  FlyingSaucer: array[1..5] of INTEGER = (
  500,200,28,5,0);
  Siren: array[1..9] of INTEGER = (
  200,1,2,800,
  1000,-1,2,800,0);
  Drip: array[1..9] of INTEGER = (
  1000,100,8,3,
  -1,0,600,1,0);
  Train: array[1..5] of INTEGER = (
  1700,-4,1,416,0);
  Whoop: array[1..5] of INTEGER = (
  900,1,5,100,0);  
  Phaser: array[1..5] of INTEGER = (
  300,100,6,15,0);
Type
  {
    You must modify the number 13 below so that
    it equals the number of cells in the biggest
    array of the constants above.
  }

  IntArray = array[1..13] of INTEGER;

implementation

procedure SndEff(Info:  POINTER);
{ Generate sounds according to the Info table.  Each table entry contains the
  following:

      Starting Tone in Hz
      Freq. change in Hz per repetition
      Milliseconds between changes
      Number of repetitions

  The table can repeat these parameters as many times as necessary.  To end
  the table a single 0 is required.
}
var
  Table:  ^IntArray;
  i,tone,
  offset:  INTEGER;
begin
  offset := 0;					{init. offset into table}
  Table := Info;				{set pointer}
  repeat
    tone := Table^[offset+1];			{get initial tone}
    for i := 1 to Table^[offset+4] do begin	{for each repetition...}
      if tone < 0 then
        NoSound
      else
        Sound(tone);				{start a sound}
      Delay(Table^[offset+3]);			{set duration}
      tone := tone + Table^[offset+2];		{change tone}
    end; {for i}
    offset := offset + 4;			{increment offset into table}
  until Table^[offset+1] = 0;			{until end of table}
  NoSound;
end; {SoundEff procedure}

end.
