/* sound generation and timing interrupt
 *
 * Last change: 10 July 92  JMG
 *
 * Written by:
 *
 *   Nels Anderson
 *   92 Bishop Drive
 *   Framingham, MA  01701
 *
 * Translated to (Borland) C by:
 *
 *   John Gallant
 *   1249 Cedar Creek Circle
 *   Dayton OH 45459
 *
 * Released to the public domain
 */


#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "\sound\sounder.h"


char SoundSpeed;	/* multiplier used to slow down sounds*/
char SoundCount;	/* counts how long current sound has been on*/
char far *MySound;		/* points to array of notes and durations*/
#if CPPStyle
void interrupt (*New1CInt)(...);	/* address of new interrupt*/
void interrupt (*Int1CSave)(...);	/* saves original $1C interrupt*/
#else
void interrupt (*New1CInt)();	/* address of new interrupt*/
void interrupt (*Int1CSave)();	/* saves original $1C interrupt*/
#endif
int NumRepeats;		/* number of times to repeat sound*/
int MyClock;		/* general purpose timer*/
int SoundOff;		/* offset into note array*/
char SndFlg;		/* set when sounds allowed*/
char MakeSound;		/* set while sound is going*/


/* functions *******************************************/

void far InitSound(void)
/* initializes and starts the sound controller (but not the sound)
 * the controller uses the timer interrupt (1C)
 */
{
  SndFlg = TRUE;		/* sounds are allowed */
  MakeSound = FALSE;		/* sound initially off */
  MyClock = 0;			/* reset timer */
  New1CInt = TimerInt;		/* get address of interrupt */
}


void far StartSound(char far Notes[], int Repeats, char Speed)
/*  Start generating the sound pointed to by Notes */
{
  SoundSpeed = Speed;		/* set speed */
  SoundOff = 0;			/* offset into sound array */
  SoundCount = 1;		/* counter for current note */
  MySound = Notes;		/* pointer to sound array */
  NumRepeats = Repeats;		/* number times to repeat sound */
  MakeSound = TRUE;		/* enable sounds */
} /* StartSound() */


#if CPPStyle
void interrupt TimerInt(...)
#else
void interrupt TimerInt()
#endif
/*  Clock tick interrupt
 *
 * BIOS interrupt 0x1C has been replaced with the following routine.  This
 * interrupt occurs on each clock tick (18 per second).
 *
 * The interrupt mainly handles sounds.  When the MakeSound flag is true,
 * the pointer MySound must be pointing to a byte array containing durations
 * and frequencies of sounds to be generated.  Sounds will be generated from
 * the array until a duration of 0 is found.
 *
 * A general purpose timer is also incremented each time the interrupt
 * occurs.
 *
 * To use the interrupt, the main program needs to do the following:
 *
 * {
 *   GetIntVec(0x1C,Int1CSave);		(save original interrupt vector)
 *   SetIntVec(0x1C,New1CInt);		(install timer interrupt)
 * 	  .
 * 	  .				(body of program)
 * 	  .
 *   StartSound(PhaserSound,3,1);	(phaser sound 3 times, normal speed)
 * 	  .
 * 	  .				(body of program)
 * 	  .
 *   SetIntVec(0x1C,Int1CSave);		(restore original 1C interrupt)
 * }
 *
 */
{
  MyClock++;				/* increment timer */
  if (!SndFlg) { 			/* exit if sounds turned off */
    MakeSound = FALSE;
  } else if (MakeSound) {		/* if making a sound...*/
    SoundCount--;
    if (SoundCount <= 0) { 		/* if current sound done...*/
      nosound();
      SoundCount = SoundSpeed*MySound[SoundOff];	/* get duration of next one*/
      if (SoundCount > 0) { 		/* if there is a next one...*/
	SoundOff++;
	sound(10*MySound[SoundOff]);	/* start it up */
	SoundOff++;
      } else { 				/* if end of sound array...*/
	NumRepeats--;			/* decrement number of repeats */
	if (NumRepeats > 0) { 		/* if we must repeat...*/
	  SoundOff = 2;			/* reset offset into array */
	  SoundCount = MySound[0];	/* get duration of first note */
	  sound(10*MySound[1]);		/* start it up */
	} else {			/* if all repeats now done... */
	  nosound();			/* stop all sound */
	  MakeSound = FALSE;		/* reset flag */
	}
      }
    }  /* if SoundCount = 0 */
  }  /* if making a sound */
}  /* TimerInt() */

