/* sound generation and timing interrupt
 * sample sounds
 *
 * Last change:  10 Jul 92  JMG
 *
 * Written by:
 *
 *   Nels Anderson
 *   92 Bishop Drive
 *   Framingham, MA  01701
 *
 * Translated to (Borland) C by:
 *
 *   John Gallant
 *   1249 Cedar Creek Circle
 *   Dayton OH 45459
 *
 * Released to the public domain
 */

#include "sndnotes.h"

/*
 Sound Collection:

  Each sound is an array of pairs of bytes, where the first byte of each
  pair is the duration in 1/18th second units and the second byte of the
  pair is the note frequency in 10's of Hertz.  To use a sound, include
  a command like the following in a program:

	   StartSound(PhaserSound,3,1);	/ * do phaser sound 3 times * /

 */

char Ruddigore[] = {		/* theme song */
  18,000,		/* start delay */
  3,000,
  3,DN4,1,DN4, 2,DN4,2,DN4,8,FN4,4,DN4,
  2,DN4,2,DN4,8,AN4,3,AN4,1,AN4,
  4,DN5,2,AN4,2,AN4,4,AN4,4,BN4, 12,CN5,4,CN4,
  2,CN4,2,CN4,8,EN4,2,CN4,2,CN4,
  2,CN4,2,CN4,8,GN4,4,CN4, 4,CN5,2,CN5,2,CN5,2,CN5,2,DF5,4,BF4,
  12,AF4,3,AF4,1,AF4,
  4,FF4,4,FF4,6,AF4,2,FF4, 4,EF4,4,EF4,6,AF4,2,AF4,
  4,FF4,4,FF4,4,AF4,2,AF4,2,AF4, 12,BN4,4,EN4,
  4,AN4,4,AN4,4,AN4,2,BN4,2,CS5,
  4,DN5,4,AN4,4,FN4,4,DN4, 4,AN4,4,AN4,4,AN4,2,BN4,2,CS5,
  6,DN5,2,FN5,4,FN5,4,DN5, 4,DN5,2,DN5,2,DN5,4,CS5,4,CS5,
  6,DN5,2,FN5,4,FN5,4,DN5, 4,DN5,4,CS5,4,CN5,4,AF4,
  4,CN5,4,BN4,4,BF4,4,GN4, 4,CS5,4,AN4,4,FS4,4,FN3,
  8,AN4,8,AN3, 8,DN4,8,000,

  3,DN4,1,DN4, 2,DN4,2,DN4,8,FN4,4,DN4,
  2,DN4,2,DN4,8,AN4,3,AN4,1,AN4,
  4,DN5,2,AN4,2,AN4,4,AN4,4,BN4, 12,CN5,4,CN4,
  2,CN4,2,CN4,8,EN4,2,CN4,2,CN4,
  2,CN4,2,CN4,8,GN4,4,CN4, 4,CN5,2,CN5,2,CN5,2,CN5,2,DF5,4,BF4,
  12,AF4,3,AF4,1,AF4,
  4,FF4,4,FF4,6,AF4,2,FF4, 4,EF4,4,EF4,6,AF4,2,AF4,
  4,FF4,4,FF4,4,AF4,2,AF4,2,AF4, 12,BN4,4,EN4,
  4,AN4,4,AN4,4,AN4,2,BN4,2,CS5,
  4,DN5,4,AN4,4,FN4,4,DN4, 4,AN4,4,AN4,4,AN4,2,BN4,2,CS5,
  6,DN5,2,FN5,4,FN5,4,DN5, 4,DN5,2,DN5,2,DN5,4,CS5,4,CS5,
  6,DN5,2,FN5,4,FN5,4,DN5, 4,DN5,4,CS5,4,CN5,4,AF4,
  4,CN5,4,BN4,4,BF4,4,GN4, 4,CS5,4,AN4,4,FS4,4,FN3,
  8,AN4,8,AN3,
  4,DN4,2,000,2,GN3,4,DN4,2,000,2,GN3,
  4,DN4,2,000,2,GN3,2,DN4,2,GN3,2,DN4,2,GN3,
  4,DN4,4,000,4,DN4,4,000, 16,DN4,0
};


char Canon[] = {
  18,000,		/* start delay */
  4,000,4,FS5,4,EN5,4,DN5, 4,EN5,4,DN5,4,CS5,8,BN4,	/* 1-2 */
  4,FS5,4,EN5,4,DN5,4,DN5, 4,CS5,4,BN4,4,AN4,4,CS5,	/* 3-4 */
  4,000,4,BN5,4,AN5,4,GN5, 8,AN5,4,BN5,4,CS6,		/* 5-6 */
  8,DN6,8,BN5, 4,FS5,4,EN5,4,FS5,2,AN4,2,GN4,		/* 7-8 */
  4,FS5,4,EN5,4,FS5,4,AN5, 8,FS5,4,FS5,4,EN5,		/* 9-10 */
  4,DN5,2,DN5,2,EN5,4,FS5,4,BN5, 8,BN5,4,000,4,AN5,	/* 11-12 */
  4,GN5,2,FS5,2,EN5,4,DN5,4,EN4, 4,FS4,4,000,4,DN5,4,FS4,
  4,GN4,4,DN5,4,EN5,4,DN5, 2,CS5,2,BN4,8,AN4,4,000,	/* 15-16 */
  2,FS4,2,AN4,2,FS4,2,AN4,2,FS4,2,AN4,2,FS4,2,AN4,	/* 17 */
  2,EN4,2,AN4,2,EN4,2,AN4,2,EN4,2,AN4,2,EN4,2,AN4,	/* 18 */
  2,FS4,2,BN4,2,FS4,2,BN4,2,FS4,2,BN4,2,FS4,2,AN4,	/* 19 */
  2,AN4,2,CS5,2,FS5,2,GN5,2,FS5,2,DN5,2,AN4,2,CS5,	/* 20 */
  2,AN4,4,DN5,4,GN5,2,DN5,2,CS5,2,BN4,			/* 21 */
  2,DN5,2,CS5,8,DN5,4,DN5,				/* 22 */
  2,DN4,2,BN4,2,CS5,2,BN4,4,DN5,2,EN5,2,DN5,		/* 23 */
  2,CS5,2,BN4,8,AN4,2,EN4,2,AN4,			/* 24 */
  4,FS5,4,DN5,4,FS4,4,FS5,				/* 25 */
  4,EN5,4,AN4,1,EN5,1,FS5,1,EN5,1,FS5,1,EN5,1,FS5,2,EN5,
  4,DN5,4,BN4,4,FS4,4,DN5,				/* 27 */
  4,CS5,4,AN4,1,CS5,1,DN5,1,CS5,1,DN5,1,CS5,1,BN4,2,CS5,/* 28 */
  4,BN4,4,DN5,4,BN4,4,GN4,				/* 29 */
  1,FS4,1,AN4,1,DN5,1,FS5,1,AN4,1,DN5,1,FS5,1,AN5,	/* 30 */
  1,DN5,1,FS5,1,AN5,1,BN5,1,AN5,1,GN5,1,FS5,1,EN5,
  4,DN5,4,BN4,2,GN4,2,BN4,2,CS5,2,DN5,			/* 31 */
  4,CS5,4,EN5,1,AN5,1,BN5,1,AN5,1,BN5,1,AN5,1,BN5,2,GN5,/* 32 */
  1,FS5,1,EN5,1,DN5,1,AN4,1,FS4,1,EN4,1,BN4,1,AN3,	/* 33 */
  1,DN6,1,GN5,1,FS5,1,DN5,1,AN4,1,GN4,1,FS4,1,DN4,
  1,EN5,1,DN5,1,CS5,1,BN4,1,CS5,1,GN4,1,FS4,1,EN4,	/* 34 */
  1,GN5,1,FS5,1,EN5,1,DN5,1,CS5,1,BN4,1,AN4,1,GN4,
  1,DN5,1,CS5,1,BN4,1,FS4,1,DN4,1,CS4,1,BN3,1,FS3,	/* 35 */
  1,BN5,1,EN5,1,DN5,1,CS5,1,BN4,1,AN4,1,GN4,1,FS4,
  1,CS5,1,BN4,1,AN4,1,GN4,1,AN4,1,EN4,1,DN4,1,CS4,	/* 36 */
  1,AN5,1,GN5,1,FS5,1,EN5,1,DN5,1,CS5,1,BN4,1,AN4,
  1,BN4,1,AN4,1,GN4,1,FS4,1,FS4,1,DN4,1,CS4,1,BN3,	/* 37 */
  1,GN4,1,BN4,1,CS5,1,DN5,1,GN5,1,AN5,1,BN5,1,DN6,
  1,FS6,1,EN6,1,DN6,1,AN5,1,FS5,1,EN5,1,DN5,1,AN4,	/* 38 */
  1,DN5,1,EN5,1,FS5,1,GN5,1,AN5,1,BN5,1,CS6,1,DN6,
  1,GN5,1,FS5,1,EN5,1,DN5,1,CS5,1,BN4,1,AN4,1,GN4,	/* 39 */
  1,BN5,1,AN5,1,GN5,1,FS5,1,EN5,1,DN5,1,CS5,1,BN4,
  1,CS6,1,BN5,1,AN5,1,GN5,1,FS5,1,EN5,1,DN5,1,CS5,	/* 40 */
  1,AN4,1,GN4,1,FS4,1,EN4,1,DN4,1,CS4,1,BN3,1,AN3,
  8,DN5,8,AN4, 8,CS5,8,AN4, 8,BF4,8,FN4,
  8,BF4,4,000,4,BF4, 8,BF4,8,AN4, 16,AN4,16,DN5,0
};


char PhaserSound[] = {1,30, 1,31, 0};

char TorpSound[] = {1,8, 1,9, 1,8, 1,20, 1,21, 1,22, 0};

char WhistleSound[] = {4,50, 10,100, 0};


char Scale[] = {
  4,CN4, 4,DN4, 4,EN4, 4,FN4, 4,GN4, 4,AN4, 4,BN4, 4,CN5, 8,000, 0
};
