/* SPKPLAY V1.1a - a program to demonstrate the capabilities of the
 * TSPKSVD package.
 * (c) 1993 Christian Wagner, Tale Software. This is FREEWARE.
 */

#include <alloc.h>	/* memory allocation */
#include <fcntl.h>      /* open flags */
#include <io.h>		/* file handling */
#include <stdio.h>      /* standard i/o */

#include "tspksvd.h"	/* def. file for sampled voice driver */

/* for strtouword:
 * error in converting a string into an uword, must be negative
 */
#define STR_CONV_ERR -1

/* for main:
 * return this errorlevels to DOS if something went wrong
 */
#define ERR_NO 0
#define ERR_CMDLINE 1
#define ERR_PLAYFREQ 2
#define ERR_NOMEM 3
#define ERR_NOFILE 4

/* size of sampled voice buffer */
#define PLAYBUFSIZE 262144L /* why not 262144? I like 'magic' numbers */

/*******************************************************************/
/* strtouword (V2.3)                                               */
/* converts a decimal string (0..32767) into an uword. 	           */
/* allowed chars in the string: 0..9                               */
/*                                                                 */
/* word value=strtouword(char *string)			           */
/* if value is STR_CONV_ERR then the string contains invalid chars */
/*******************************************************************/
word strtouword(char *decstr)
{ word result=0;

  while (*decstr)
  { if ((*decstr<'0') || (*decstr>'9')) { result=STR_CONV_ERR; break; };
    result=(result*10)+(*decstr++-'0');
  };
  return(result);
}

main(uword argc,char *argv[])
{ ubyte error=ERR_NO,scalefactor,far *svbuf,huge *svbuftmp;
  byte offset,eofile=FALSE;
  int readhandle;
  word playfreq;
  uword readsize;
  udword svsize,svbufsize;

  /* check command line */
  argc-=1;
  if (argc!=2) { printf("Usage: SPKPLAY play_frequency raw_sound_file\n\nParameters:\nplay_frequency: may range from 4679Hz - 22050Hz\nraw_sound_file: should be a headerless unsigned sampled voice\n\nSPKPLAY V1.1a - a sampled voice player for the PC speaker\n(c) 1993 Christian Wagner, Tale Software. This is freeware.\n"); return(ERR_CMDLINE); };

  /* interpret play frequency */
  playfreq=strtouword(argv[1]);
  if (playfreq==STR_CONV_ERR || playfreq<SPKSVMINFREQ || playfreq>SPKSVMAXFREQ) { printf("?Invalid play frequency\n"); return(ERR_PLAYFREQ); };

  /* allocate memory for playback */
  svbuf=farmalloc(PLAYBUFSIZE);
  if (!svbuf) { printf("?Insufficient memory\n"); return(ERR_NOMEM); };

  /* open input file */
  readhandle=open(argv[2],O_RDONLY|O_BINARY);
  if (readhandle==-1) { printf("?Error opening %s\n",argv[2]); error=ERR_NOFILE; goto cleanup; };

  /* find out scaling and offset:
   * I have defined 3 playback bands:
   *  4679 Hz -  9394 Hz: no scaling, offset=(playfreq-4679)/-127
   *  9395 Hz - 13546 Hz: scale SV to 75%, offset=((playfreq-9395)/-289)-4
   * 13547 Hz - 22050 Hz: scale SV to 50%, offset=(playfreq-13547)/-674)
   */
  if (playfreq<9395) { scalefactor=0; offset=(playfreq-4679)/-127; }
     else if (playfreq<13547) { scalefactor=2; offset=((playfreq-9395)/-289)-4; }
     else { scalefactor=1; offset=(playfreq-13547)/-674; };

  /* print information about scaling and offset */
  if (scalefactor) printf("scaling SV to %u%%, ",100-(100/(2<<(scalefactor-1))));
  printf("offset: %d\n",offset);

  while (!eofile)
  { /* fill sampled voice buffer */
    for (svbufsize=PLAYBUFSIZE,svsize=0,svbuftmp=svbuf;svbufsize>32767;svbufsize-=32767,svbuftmp+=32767)
    { readsize=_read(readhandle,svbuftmp,32767);
      svsize+=readsize;
      if (readsize<32767) { eofile=TRUE; break; };
    };
    if (!eofile&&svbufsize) { readsize=_read(readhandle,svbuftmp,(uword)svbufsize);
			      svsize+=readsize;
			      if (readsize<(uword)svbufsize) eofile=TRUE;
			    };

    /* play sampled voice */
    playspksv(scalefactor,offset,playfreq,svsize,svbuf);

    /* wait for playback */
    waitspksv();
  };

cleanup:
  farfree(svbuf);
  if (readhandle!=-1) close(readhandle);
  return(error);
}
