/* TSPKSVD.H already included? */
#ifndef TSPKSVD_H
#define TSPKSVD_H

/* define bool values as understood by tale software */
#ifndef BOOL
 #define BOOL
 #define TRUE -1
 #define FALSE 0
#endif

/* define origin data types as understood by tale software */
#ifndef TALE_DATA_TYPES
 #define TALE_DATA_TYPES
 typedef unsigned char ubyte;	   /* unsigned byte */
 typedef signed char byte;	   /* signed byte */
 typedef unsigned int uword;	   /* unsigned word */
 typedef signed int word;	   /* signed word */
 typedef unsigned long int udword; /* unsigned double word */
#endif

#define SPKSVMINFREQ 4679          /* min. allowed play frequency */
#define SPKSVMAXFREQ 22050         /* max. allowed play frequency */

/* these procedures are currently available */
byte playspksv(ubyte rshift,byte offset,uword freq,udword len,ubyte far *wave);
byte resumespksv(void);
byte queryspksv(void);
void waitspksv(void);
byte abortspksv(void);

#endif /* TSPKSVD_H */
