/**************************************************************************

  EXAMPLE1.C

  Written by Eric Jorgensen (1995)

  The is an example program to illustrate how to use Varmint's Audio
  Tools to play .wav files.


**************************************************************************/

#include "sound.h"
#include <conio.h>


void main(void)
{
  float d;
                                           // You need two variables to keep
                                           // track of the data and length of
                                           // the loaded wave file.
  SAMPLE *sound1;
  DWORD length1;
                                          // You will also need one variable
                                          // for the sound handle if you want
                                          // to do anything with the sound
                                          // while it is playing.
  DWORD id1;

                                           // In general, it is good to perform
                                           // all file access before settup
                                           // up the sound blaster.
  sound1 = LoadWave("aha.wav",&length1);
  if(!sound1) printf("ERROR loading sound:  aha.wav\n");

                                           // Set up the sound blaster.
  if(!SBSetUp()) {
    printf("SB_Setup returned this error: %s \n",errname[sberr]);
    if(sound1) farfree(sound1);
    exit(1);
  }

  GoVarmint();                            // Start up the sound Kernel.

  PlaySound(sound1,length1,v_plain);      // Play a sound effect.

  printf("Press a key to continue.\n");
  getch();
                                          // Now let's play a sound effect
                                          // and use AlterSoundEffect to
                                          // change the frequency while it
                                          // is playing.
  id1 = PlaySound(sound1,length1,v_fancy);
  for(d = 0.1; d < 3; d += 0.01) {
    AlterSoundEffect(id1,v_setrate,d);    // Change the frequency.
    MilliDelay(10);                       // Wait a few milliseconds.
  }

  printf("Press a key to quit.\n");
  getch();

  DropDeadVarmint();                      // Stop the SB interrupt.
  SBCleanUp();                            // Clean up sound stuff.
  if(sound1) farfree(sound1);             // Free our sond effect.

}