/**************************************************************************

  EXAMPLE3.C

  Written by Eric Jorgensen (1995)

  The is an example program to illustrate how to use Varmint's Audio
  Tools to play MOD files.


**************************************************************************/

#include "sound.h"
#include <conio.h>


void main(void)
{
  int i;
                                          // You need a MOD structure to
                                          // hold the data from the MOD file.
  MOD *song;
                                          // You will also need a character
                                          // string to catch any error
                                          // messages from LoadMod().
  char errstring[100];

                                          // In general, it is good to perform
                                          // all file access before settup
                                          // up the sound blaster.
  song = LoadMod("noname.mod",errstring);
  if(!song) {
    printf("ERROR loading MOD:  %s\n",errstring);
    exit(1);
  }
                                          // Set up the sound blaster.
  if(!SBSetUp()) {
    printf("SB_Setup returned this error: %s \n",errname[sberr]);
    FreeMod(song);                        // Free the MOD you just loaded.
    exit(1);
  }

  SetSampleRate(22000);                   // Mods sound better with a
                                          // fast mixing rate. (Make sure you
                                          // SetSampleRate() before you call
                                          // GoVarmint().


  GoVarmint();                            // Start up the sound Kernel.

  mod_data = song;                        // Tell VAT which song to play.
  ModCommand(v_play);                     // Start the music!

  printf("Press a key to quit.\n");
  while(!kbhit());
//  getch();

  DropDeadVarmint();                      // Stop the SB interrupt.
  SBCleanUp();                            // Clean up sound stuff.
  FreeMod(song);                          // Free our sond effect.

}
