/**************************************************************************
  VATDEMO.C

  Written by:  Eric Jorgensen (Aug, 1995)

  This code was written using Turbo C.  It is intended to demonstrate the
  use of Varmint's Audio Tools and to provide a example code for programers
  who wish to use VAT.

                          This code is FREEWARE

  You are free to distribute without any restrictions as long as you
  charge no fee.


**************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <malloc.h>
#include "sound.h"
#include <math.h>
#include <time.h>
#include <STDARG.H>
#include <graph.h>
#include "compat.h"


#define getbit(x,y) ((x>>y) & 0x01)
#define setbit(x,y) x = x & (0x01<<y)
#define togbit(x,y) x = x ^ (0x01<<y)

                                  // function prototypes
void fmdemo(void);
void mididemo(void);
void sb_intro(void);
void dspdemo(void);
void moddemo(void);
void vsyncdemo(void);
void introtext(void);
void diagnostics(void);
void debugoptions(void);
void vatcprintf(char *string,...);


                                 // external functions

//-------------------------- external data -----------------------
                                        // These variables are necessary to
                                        // VAT, but are not normally needed
                                        // outside of the library itself.
                                        // I've included them in the demo
                                        // to help illustrate what is
                                        // possible with VAT.

extern WORD         dma_bufferlen;
extern int          sample_rate;
extern WORD         io_addr;
extern WORD         intnr;
extern WORD         dma_ch;
extern WORD         card_id;
extern WORD         fm_addr;
extern WORD         dsp_vers;
extern WORD         vsync_toolong;
extern CHANNEL      chan[4];
extern int          sounds_in_queue;
extern BYTE         defaultpatchmap[16];
extern int          mpu_timeout;
extern int          mpu_available;
extern char         vatdebugstring[];
extern VOICE        midi_voice[];
extern int          debugnum;


//-------------------------- DATA and Globals --------------------

                                  // Instrument data
char    inst[9][11] =
  {
    { 0x03,0x01,0x00,0x00,0xF3,0xE4,0x64,0x35,0x00,0x01,0x00},  // Harpsichord
    { 0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x06,0x03,0x00},  // intro voice
    { 0x02,0x06,0x94,0x0A,0x80,0x80,0x00,0x00,0x00,0x00,0x00},  // intro voice
    { 0x00,0x04,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00},
    { 0x01,0x01,0x40,0x40,0x80,0x80,0x00,0x00,0x01,0x00,0x00},
    { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01},
    { 0xA5,0xB1,0xD2,0x80,0x81,0xF1,0x03,0x05,0x00,0x00,0x02},
    { 0x72,0x62,0x1C,0x05,0x51,0x52,0x03,0x13,0x00,0x00,0x0E},
    { 0x11,0x01,0x8A,0x40,0xF1,0xF1,0x11,0xB3,0x00,0x00,0x06}};

int vints[8] = {1,2,1,2,1,2,1,2}; // voice defs for introduction
                                  // Start/end frequencies for intro
WORD startfreq[8] = {58,117,165,233,466,660,932,1864};
WORD endfreq[8] =   {1760,880,660,440,220,165,110,55};

char *regname[11] = {             // FM register name list
  "Amp mod/ vib/ eg type/ keyscale/ multiple 1",
  "Amp mod/ vib/ eg type/ keyscale/ multiple 2",
  "Key scale level / oper out level 1",
  "Key scale level / oper out level 2",
  "attack/decay rate 1",
  "attack/decay rate 2",
  "sustain level / release rate 1",
  "sustain level / release rate 2",
  "Feedback / Algorythm (oper 1&2)",
  "Wave Form  Select (oper 1)",
  "Wave Form  Select (oper 1)"
  };

char *effect_primary[] = {        // MOD command names
  "Arpeggio",
  "PortaM up",
  "PortaM down",
  "Porta NOTE",
  "Vibrato",
  "porta+vol",
  "Vib+vol",
  "Tremolo",
  "UNUSED",
  "Set offset",
  "Vol slide",
  "Postn Jmp",
  "Set Volume",
  "Pat Break",
  "special14",
  "Set Speed"};
char *effect_secondary[] = {
  "Filter T/F",
  "Finesld up",
  "Finesld dn",
  "Gliss T/F",
  "Vibr WF",
  "Finetune WF",
  "Loop Pattrn",
  "Tremolo WF",
  "UNUSED",
  "Retrigger",
  "FineVolS up",
  "FineVolS Dn",
  "Cut Sample",
  "Delay Sampl",
  "Delay Pttrn",
  "Invert Loop"};
                                          // Patchmap to work on really
                                          // lame MIDI ouput devices.
BYTE mypatchmap[16] = {0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,2};
                                          // Initial FM patchmap to set
                                          // tracks 1 and 2 to harpsichord
BYTE myfmpatchmap[32] = {0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,
                           0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
char *instname[16] = {"ACGPIANO","ACPiano","ELGPIANO","HONKTONK","ELPIANO1",
        "ElPiano2","HARPSCHD","CLAVICHD","CELESTA","GLOCK","MUSICBOX",
        "VIBES","MARIMBA","XYLOPHON","TUBEBELL","Dulcimer"};


char hexchar[16] = {"0123456789ABCDEF"};  //  hexidecimal character list

char errstring[256];
SAMPLE *sound1,*sound2,*aha,*rumble;
DWORD l1=1,l2=1,laha=1,lrum;
FILE *diagoutput= NULL;
int mpu_checked = FALSE;
DWORD memleft;
MIDI *bachmidi  = NULL;
MOD *mymod = NULL;
char modfilename[255] = {"noname.mod"};

extern int directvideo;

/**************************************************************************
  void main()

  DESCRIPTION:   Handles the main menu and sets things up

**************************************************************************/
void main(int argc,char *argv[])
{
  int i= 0;
  char r = 0,twirl[6]  = "|/-\\";


  if(argc > 1 && *(argv[1]) != '-') strcpy(modfilename,argv[1]);

  _setcursortype(_NOCURSOR);             // eliminates flashing text

  introtext();
  diagnostics();
                                         // Load up our sound effects
  sound1 = LoadWave("doink.wav",&l1);
  if(!sound1) printf("ERROR loading sound:  doink.wav\n");

  sound2 = LoadWave("wooeep.wav",&l2);
  if(!sound2) printf("ERROR loading sound:  wooeep.wav\n");

  aha = LoadWave("aha.wav",&laha);
  if(!aha) printf("ERROR loading sound:  aha.wav\n");

  rumble = LoadWave("rumble.wav",&lrum);
  if(!aha) printf("ERROR loading sound:  rumble.wav\n");

                                              // load a midi file
  bachmidi = LoadMidi("bach.mid",(char *)errstring);
  if(!bachmidi) {
    printf("MIDI read ERROR: %s\n",errstring);
  }
  midi_data = bachmidi;

                                        // Load MOD file
  mymod = LoadMod(modfilename,(char *)errstring);
  if(!mymod) {
    printf("%s",errstring);
  }
  mod_data = mymod;


  if(!sound1 || !sound2 || !aha || !rumble || !bachmidi ||!mymod) {
    printf("Press any key\n");
    getch();
  }


                                       // THis is a little snippet of code
                                       // Thad adds useful info to the
                                       // Survey.txt file.
  if(diagoutput) {
    if(!sound1 || !sound2 || !aha) {
      fprintf(diagoutput,"Error loading sounds\n");
    }
    fflush(diagoutput);
    fclose(diagoutput);
    diagoutput = NULL;
  }

//  memleft = farcoreleft();              // Keep a tab on memory for debugging
                                        // purposes.
clrscr();
gotoxy(0,0);
  if(SBSetUp()) {
    gotoxy(0,1);
    if(argc > 1 && *(argv[1])=='-' && toupper(*(argv[1]+1)) == 'D') {
                                        // for deugging. If any -d argument is
                                        // Passed to main,  debugging info
                                        // Will be dumped to survey.txt
      diagoutput = fopen("survey.txt","a");
      if(diagoutput) {
        fprintf(diagoutput,"%s",vatdebugstring);
        fflush(diagoutput);
        fclose(diagoutput);
      }
    }


    TimeVSync();                        // Check the length of the vertical
                                        // Retrace so VarmintVSync will
                                        // Work Properly

    GoVarmint();                            // Install  Varmint's tools

    sb_intro();                             // Get someone's attention

    while(kbhit()) getch();
    while(r != 'Q') {                       // Main input loop

      clrscr();                             // CLear screen and draw menu
//      textcolor(DARKGRAY);
//      vcprintf("Memory change %ld ",farcoreleft()-memleft);
//      memleft = farcoreleft();

      textcolor(WHITE);
      gotoxy(20,8);
      vatcprintf("Demonstration:  Varmint's Audio Tools (%s)\n\n",VAT_VERSION);
      textcolor(YELLOW);
      gotoxy(30,10);
      vatcprintf("1) FM voice");
      gotoxy(30,11);
      vatcprintf("2) MIDI");
      gotoxy(30,12);
      vatcprintf("3) Sounds");
      gotoxy(30,13);
      vatcprintf("4) MOD");
      gotoxy(30,14);
      vatcprintf("5) VSYNC");
      gotoxy(30,15);
      vatcprintf("6) DEBUGGING");
      gotoxy(30,16);
      vatcprintf("7) INTRO");
      gotoxy(30,20);
      vatcprintf("Q) quit");

      while(!kbhit()) {                     // Draw a twirling thing while
                                            // we wait for a keypress.
        gotoxy(35,18);
        vatcprintf("%c",twirl[++i%4]);
        gotoxy(1,1);
        MilliDelay(50);
      }
      r = toupper(getch());                 // grab some input

      if(r == '1') fmdemo();                // Do something with it
      else if(r == '2') mididemo();
      else if(r == '3') dspdemo();
      else if(r == '4') moddemo();
      else if(r == '5') vsyncdemo();
      else if(r == '6') debugoptions();
      else if(r == '7') sb_intro();
    }
    DropDeadVarmint();                     // Release Varmint's interrupt
    SBCleanUp();                           // Clean house before we go.
    clrscr();                               // Clear the screen
  }
  else {
    printf("SB_Setup returned this error: %s \n",errname[sberr]);
  }

  if(sound1) free(sound1);              // Free up used memory
  if(sound2) free(sound2);
  if(aha) free(aha);
  if(rumble) free(rumble);
  if(bachmidi) FreeMidi(bachmidi);
  if(mymod) FreeMod(mymod);
                                             // Dump debug info to survey.txt
  diagoutput = fopen("survey.txt","a");
  if(diagoutput) {
//    fprintf(diagoutput,"End Core left: %lu\n",farcoreleft());
    fprintf(diagoutput,"%s",vatdebugstring);
    fflush(diagoutput);
    fclose(diagoutput);
  }

  gotoxy(1,24);
  textcolor(LIGHTGRAY);
  _setcursortype(_NORMALCURSOR);           // Brings cursor back */
}


/**************************************************************************
  void vsyncdemo(void)

  DESCRIPTION: The demonstrates the use of VarmintVSync() for animation

**************************************************************************/
void vsyncdemo(void)
{
  int x=5;
  char *drawme = {"HONIG"};
  char r=0;

  clrscr();

                                    // Display intro text.
  gotoxy(2,16);
  textcolor(CYAN);
  vatcprintf("VAT's mixing kernel can interfere with ordinary functions that\r\n");
  vatcprintf("monitor the vertical retrace bit, causing `jerky' animation.\r\n");
  vatcprintf("With sync checking off, the animation above will jerk badly\r\n");
  vatcprintf("when you play sounds.  (This does not work well with MOD's\r\n");
  vatcprintf("on slow computers like 386's.)\r\n\n");
  textcolor(LIGHTGRAY);
  vatcprintf("Press 1,2, or 3 to play sounds.\r\n");
  vatcprintf("Press <space> to toggle sync checking, 'Q' to quit");

  gotoxy(60,23);                    // Display status of sync_on
  textcolor(YELLOW);
  if(sync_on) vatcprintf("SYNC ON  ");
  else vatcprintf("SYNC OFF ");

  while(toupper(r) != 'Q') {        // Input/animation loop
    if(kbhit()) {                   // Key stroke waiting?
      r = getch();
      if(r == ' ') {                // toggle sync checking
        sync_on ^= TRUE;
        gotoxy(60,23);
        if(sync_on) vatcprintf("SYNC ON  ");
        else vatcprintf("SYNC OFF ");
      }                             // Play sounds
      else if(r == '1') PlaySound(sound1,l1,v_plain);
      else if(r == '2') PlaySound(sound2,l2,v_plain);
      else if(r == '3') PlaySound(aha,laha,v_plain);
    }

                                    // Animate a little bit of text
    gotoxy(x,4);
    vatcprintf("     ");

    x++;
    if(x>74) x= 1;

    gotoxy(x,4);
    vatcprintf("%s",drawme);

    VarmintVSync();                 // Wait for a retrace to finish

  }
}


/**************************************************************************
  moddemo(void)

  DESCRIPTION: Demo for playing MOD files

**************************************************************************/
void moddemo(void)
{
  int i,playme = 0;
  char r=0;
  DWORD count=0,total=0;
  double oh;

  clrscr();                             // Clear the screen


  DSP_overhead = 1;                     // Turn on overhead checking

  textcolor(WHITE);
  gotoxy(4,1);
  vatcprintf("MOD demo menu");                 // Draw the menu
  textcolor(CYAN);
  gotoxy(4,3);
  vatcprintf("1       - Start music");
  gotoxy(4,4);
  vatcprintf("2       - Stop music");
  gotoxy(4,5);
  vatcprintf("3       - Pause music");
  gotoxy(4,6);
  vatcprintf("4       - Resume music");
  gotoxy(4,7);
  vatcprintf("5       - Rewind music");
  gotoxy(4,8);
  vatcprintf("V,v     - Change music volume");
  gotoxy(4,9);
  vatcprintf("T,t     - Change music tempo");
  gotoxy(4,10);
  vatcprintf("S       - Select sample");
  gotoxy(4,11);
  vatcprintf("<Space> - Play Current sample");
  gotoxy(4,13);
  vatcprintf("Q       - Quit");

  textcolor(LIGHTMAGENTA);
  gotoxy(2,16);
  vatcprintf("MOD Title: %s ",mymod->title);

  for(i = 0; i < 4; i++) {
      gotoxy(2,18+i);                               // Print Channel labels
      vatcprintf("CHANNEL%d:",i+1);
  }

  textcolor(LIGHTGRAY);
  gotoxy(35,8);                                     // SHow current volume
  vatcprintf("VOLUME BYTE: %d  ",mod_volume);
  gotoxy(35,9);                                     // Show the tempo
  vatcprintf("TEMPO: %d  ",mod_bytespertick);
  gotoxy(35,10);                                    // Show current sample
  vatcprintf("Current sample: %d (%s)          ",playme+1,mymod->sample_name[playme]);

  while(toupper(r) != 'Q') {                        // Input Loop
    if(kbhit()) {                                   // Keyboard have input?
      r = getch();                                  // Grab the key
      if(r == 'V') {                                // Volume louder
        mod_volume--;
        if(mod_volume < 1) mod_volume = 1;
        textcolor(LIGHTGRAY);
        gotoxy(35,8);                               // SHow current volume
        vatcprintf("VOLUME BYTE: %d  ",mod_volume);
      }
      else if(r == 'v') {                           // Volume softer
        mod_volume++;
        if(mod_volume > 16) mod_volume = 16;
        textcolor(LIGHTGRAY);
        gotoxy(35,8);                               // SHow current volume
        vatcprintf("VOLUME BYTE: %d  ",mod_volume);
      }
      else if(r == 'T') {                           // Tempo faster
        mod_bytespertick-=10;
        if(mod_bytespertick < dma_bufferlen) mod_bytespertick = dma_bufferlen;
        textcolor(LIGHTGRAY);
        gotoxy(35,9);                               // Show the tempo
        vatcprintf("TEMPO: %d  ",mod_bytespertick);
      }
      else if(r == 't') {                           // Tempo slower
        mod_bytespertick+=10;
        if(mod_bytespertick > 10000) mod_bytespertick = 10000;
        textcolor(LIGHTGRAY);
        gotoxy(35,9);                               // Show the tempo
        vatcprintf("TEMPO: %d  ",mod_bytespertick);
      }
      else if(r == '1') ModCommand(v_play);
      else if(r == '2') ModCommand(v_stop);
      else if(r == '3') ModCommand(v_pause);
      else if(r == '4') ModCommand(v_resume);
      else if(r == '5') ModCommand(v_rewind);
      else if(toupper(r) == 'S') {                  // Cycle through samples
        playme++;
        while(!mymod->sdata[playme]) {
          playme++;
          if(playme>31) playme = 0;
        }
        textcolor(LIGHTGRAY);
        gotoxy(35,10);                              // Show current sample
        vatcprintf("Current sample: %d (%s)        ",playme+1,mymod->sample_name[playme]);
      }                                             // Play current sample
      else if(r == ' ')
        PlaySound(mymod->sdata[playme],mymod->slength[playme],v_plain);
    }

    MilliDelay(30);                      // Wait a little bit to make the
                                         // DSP overhead average more
                                         // meaningful.

    for(i = 0; i < 4; i++) {
      textcolor(YELLOW);


      gotoxy(16,18+i);                   // Print sample number
      if(*chan[i].pos <= chan[i].end) {
        vatcprintf("%d",(int)chan[i].sample_number);
      }
      else vatcprintf("   ");

      gotoxy(22,18+i);
      if(*chan[i].pos <= chan[i].end) {
        if(chan[i].effect != 14) vatcprintf("%s       ",effect_primary[chan[i].effect]);
        else vatcprintf("%s (E)      ",effect_secondary[chan[i].x]);
      }
      else vatcprintf("                  ");

      gotoxy(42,18+i);
      vatcprintf("%d",chan[i].period);

      gotoxy(52,18+i);
      vatcprintf("%d",chan[i].volume);
    }

    count++;
    total+=DSP_overhead;
    if(count == 10) {
      oh = (total * 0.9218)/(count * dma_bufferlen) * sample_rate/11000.0;
      gotoxy(4,23);
      vatcprintf("CPU Overhead: %.2lf%% ",oh);
      total = 0;
      count = 0;
    }
  }

}


/**************************************************************************
  void dspdemo(void)

  DESCRIPTION:  Plays sound effects with Varmint's Audio Tools

**************************************************************************/
void dspdemo(void)
{
  char r = 0;
  DWORD tot = 0,num = 0,vc,id;
  static DWORD loopid;
  static int loop=0;
  int i;
  double oh;

  DSP_overhead = 1;                           // turn on overhead checking

  clrscr();                                   // Clear screen and draw a menu
  textcolor(GREEN);
  gotoxy(10,8);
  vatcprintf("Sound effects demo menu");
  textcolor(YELLOW);
  gotoxy(10,10);
  vatcprintf("       1,2,3 - Play a sound with the v_plain command");
  gotoxy(10,11);
  vatcprintf("<shift>1,2,3 - Play a sound with the v_fancy command");
  gotoxy(10,12);
  vatcprintf("           L - Toggle Looping Demo (rumble sound)");
  gotoxy(10,13);
  vatcprintf("           D - Frequency and Volume Demo");
  gotoxy(10,14);
  vatcprintf("           C - Chain Demo");
  gotoxy(10 ,17);
  vatcprintf("           Q - Quit");
  gotoxy(1,20);
  textcolor(CYAN);
  vatcprintf("    Fancy sounds use up more CPU overhead than plain sounds,\r\n");
  vatcprintf("but you can control the volume, frequency, and looping characteristics\r\n");
  vatcprintf("of fancy sounds.");

  gotoxy(1,1);
  vatcprintf("CPU OVERHEAD: \r\nSOUNDS IN QUEUE: ");
  textcolor(WHITE);
  while(toupper(r) != 'Q') {         // input loop
    while(!kbhit()) {                // Wait for keystroke
      vc = vclock;
      while(vc == vclock);           // wait for the interrupt

      tot+= DSP_overhead;            // take an average every 40 interrupts
      num++;
      if(num == 40) {
        gotoxy(15,1);
        oh = PercentOverhead((int)(tot/num))/10.0;
        vatcprintf("%2.2lf%%  ",oh); // Show overhead
        gotoxy(19,2);
        vatcprintf("%d \n",sounds_in_queue);       // Show # sounds playing
        num = 0;
        tot = 0;
      }
    }
    r = getch();                      // Get keystroke and act accordingly
                                      // Simple play commands
    if(r == '1') PlaySound(sound1,l1,v_plain);
    else if(r == '2') PlaySound(sound2,l2,v_plain);
    else if(r == '3') PlaySound(aha,laha,v_plain);
    else if(r == '!') PlaySound(sound1,l1,v_fancy);
    else if(r == '@') PlaySound(sound2,l2,v_fancy);
    else if(r == '#') PlaySound(aha,laha,v_fancy);
    else if(toupper(r) == 'L') {      // Looping demo- loop a rumble sound
      if(!loop) {
        loopid = PlaySound(rumble,lrum,v_fancy);
        AlterSoundEffect(loopid,v_setrepeat,-1);
        AlterSoundEffect(loopid,v_setvolume,32);
        loop = TRUE;
      }
      else {
        AlterSoundEffect(loopid,v_stop,0);
        loop = FALSE;
      }
    }                                 // Volume/frequncy demo
    else if(toupper(r) == 'D') {
      for(i = 1; i <16; i++ ) {       // Volume quiet->loud
        id = PlaySound(sound1,l1,v_fancy);
        AlterSoundEffect(id,v_setvolume,i*2);
        gotoxy(1,5);
        vatcprintf("Volume: %d   ",i*2);
        MilliDelay(150);
        if(kbhit()) {
          getch();
          i = 16;
        }
      }
      for(i = 1; i <16; i++ ) {       // Frequency slow->fast
        id = PlaySound(sound1,l1,v_fancy);
        AlterSoundEffect(id,v_setrate,i*32);
        gotoxy(1,5);
        vatcprintf("Rate: %d   ",i*32);
        MilliDelay(150* 8.0/i);
        if(kbhit()) {
          getch();
          i = 16;
        }
      }
      gotoxy(1,5);
      vatcprintf("                 ");    // Hide the status line

    }
    else if(toupper(r) == 'C') {      // Chain demo
      id = PlaySound(sound1,l1,v_plain);
      id = ChainSoundEffect(sound2,l2,v_plain,id);
      id = ChainSoundEffect(aha,laha,v_plain,id);
    }

  }
}

/**************************************************************************
  void sb_intro(void)

  DESCRIPTION:  Cool introduction sith sound blaster music and sounds

**************************************************************************/
void sb_intro(void)
{
  int i,j;
  double fr;
  WORD f;
  DWORD id;

  clrscr();
  gotoxy(18,12);
  textcolor(LIGHTGRAY);
  vatcprintf("Varmint's Audio Tools  (Version: %s)",VAT_VERSION);
  textcolor(RED);
  MilliDelay(500);

                                      // Cool introduction
  FMReset();
  for(i = 0; i < 3; i++) {            // "Audio Hardware Activated"
    id = PlaySound(aha,laha,v_fancy);
    if(i) AlterSoundEffect(id,v_setvolume,8-i*3);
    MilliDelay(200);
  }

  for(i = 0; i < 8; i++) {            // initialize music voices
    FMSetVoice(i,inst[vints[i]]);
    FMSetFrequency(i,startfreq[i]);
    FMSetVolume(i,0x00);
    FMKeyOn(i);
  }
  for(i = 0; i < 1000; i+= 1) {       // morph a big chord

    _disable();                       // Disable interrupts to protect
                                      // Floating point operations.

    fr = i/1000.0;
    for(j = 0; j < 8; j++) {
      gotoxy(j*10+1,10);
      f = startfreq[j]+((double)endfreq[j]-(double)startfreq[j]) * fr;
      vatcprintf("%X  ",f);
      FMSetFrequency(j,f);
      FMSetVolume(j,fr*0x3f );
      FMKeyOn(j);
    }
    _enable();
    MilliDelay(4);
    if(kbhit()) i = 1000;
  }

  if(!kbhit()) {
    for(i = 0; i < 8; i++) {          // Make sure all the notes are right
      FMSetFrequency(i,endfreq[i]);
      FMKeyOn(i);
    }

    for(i = 0x3f ; i >= 0; i-= 1) {   // quiet down slowly
      for(j = 0; j < 8; j++) {
        FMSetVolume(j,i);
      }
      MilliDelay(i*2+40);
      if(kbhit() & i) i = 1;
    }
  }

  for(i = 0; i < 9; i++) {            // Silence them all
    FMSetVolume(i,0);                   // volume off
    FMSetVoice(i,inst[0]);           // this instrument has a decay, so it
                                      // gets all the way quiet
    FMSetFrequency(i,1);                  // Low freq = quiet
  }

  if(kbhit()) getch();
}
/**************************************************************************
  void mididemo(void)

  DESCRIPTION: Example function that loads and "plays" a  midi file

**************************************************************************/
void mididemo(void)
{
  int i;
  char r=0;

  clrscr();                                   // clear screen

  FMReset();

  midi_fmpatchmap = myfmpatchmap;

/*  for(i = 0 ; i < 9; i++) {                   // initialize voices
    FMSetVolume(i,0);
    FMSetVoice ( i,inst[0]) ;
  }  */



  textcolor(MAGENTA);
  gotoxy(30,2);
  vatcprintf("MIDI demo menu");
  textcolor(CYAN);
  gotoxy(30,3);
  vatcprintf("1   - Start music");
  gotoxy(30,4);
  vatcprintf("2   - Stop music");
  gotoxy(30,5);
  vatcprintf("3   - Pause music");
  gotoxy(30,6);
  vatcprintf("4   - Resume music");
  gotoxy(30,7);
  vatcprintf("5   - Rewind music");
  gotoxy(30,8);
  vatcprintf("V,v - Change music volume");
  gotoxy(30,9);
  vatcprintf("T,t - Change music tempo");
  gotoxy(30,10);
  vatcprintf("F   - Toggle FM output: ");
  if(midi_fmout) vatcprintf("ON  ");
  else vatcprintf("OFF ");
  gotoxy(30,11);
  vatcprintf("U   - Toggle MPU output: ");
  if(midi_mpuout) vatcprintf("ON  ");
  else vatcprintf("OFF ");
  gotoxy(30,12);
  vatcprintf("P   - Set MPU-401 MIDI port");
  gotoxy(30,13);
  vatcprintf("A   - Toggle MIDI patchmap ");
  if(midi_patchmap == defaultpatchmap) vatcprintf("(16 channel)");
  else vatcprintf("( 3 channel)");
  gotoxy(30,14);
  vatcprintf("R   - Rotate FM patchmap (%s)",instname[myfmpatchmap[1]]);
  gotoxy(30,16);
  vatcprintf("Q   - Quit");

  if(!mpu_available && mpu_checked) {
    gotoxy(1,20);
    vatcprintf("Current MPU-401 midi port is invalid.");
  }


  while(toupper(r) != 'Q') {                  // MAIN LOOP
    gotoxy(30,18);                            // print temppo and volume stats
    textcolor(WHITE);
    vatcprintf("Music Volume: %d  ",midi_volume);
    gotoxy(30,19);
    vatcprintf("Music Tempo:  %d ",midi_usertempo);

    while(!kbhit()) {                         // handle the keyboard
      if(mpu_checked) {
        gotoxy(1,2);                          // check midi status while we wait
        if(mpu_timeout < 1000) vatcprintf("MPU status: OK!        ");
        else vatcprintf("MPU status: Timing out   ");
        gotoxy(1,3);
        vatcprintf("Current port: %X  ",midi_mpuport);
      }
      for(i = 0; i < 9; i++) {
        gotoxy(1,5+i);
        if(midi_voice[i].active) textcolor(YELLOW);
        else textcolor(BROWN);
        vatcprintf("Voice %d:  %d %d %d",i,midi_voice[i].note,
                    midi_voice[i].owner_track,midi_voice[i].owner_channel);
      }
    }
    r = getch();                              // get keystroke

    if(r == 'V') {                            // Handle keystrokes
      midi_volume++;
      if(midi_volume > 0x3f) midi_volume = 0x3f;
    }
    else if(r == 'v') {
      if(midi_volume > 0) midi_volume--;
    }
    else if(r == '1') MidiCommand(v_play);
    else if(r == '2') MidiCommand(v_stop);
    else if(r == '3') MidiCommand(v_pause);
    else if(r == '4') MidiCommand(v_resume);
    else if(r == '5') MidiCommand(v_rewind);
    else if(toupper(r) == 'R') {              // Rorate FM patchmap
      myfmpatchmap[1]++;
      if(myfmpatchmap[1] > 15) myfmpatchmap[1] = 0;
      myfmpatchmap[2] = myfmpatchmap[1];
      gotoxy(55,14);
      vatcprintf("(%s)     ",instname[myfmpatchmap[1]]);
    }
    else if(toupper(r) == 'A') {              // Toggle midi patchmap
      if(midi_patchmap == mypatchmap) midi_patchmap = defaultpatchmap;
      else midi_patchmap = mypatchmap;
      gotoxy(57,13);
      if(midi_patchmap == defaultpatchmap) vatcprintf("(16 channel)");
      else vatcprintf("( 3 channel)");
    }
    else if(r == 'T') {
      midi_usertempo *= 1.1;
      if(midi_usertempo > 1000) midi_usertempo = 1000;
    }
    else if(r == 't') {
      midi_usertempo *= 0.9;
      if(midi_usertempo < 10) midi_usertempo = 10;
    }
    else if(toupper(r) == 'P') {               // Get a new MPU port address
      gotoxy(1,22);
      vatcprintf("Enter new port address in hex values [%x]: ",midi_mpuport);
      gets(errstring);
      if(strlen(errstring)) sscanf(errstring,"%x",&midi_mpuport);

                                               // check for accidents
      if(midi_mpuport < 0x200 || midi_mpuport > 0x360) midi_mpuport = 0x330;
      MPUEnter();
      gotoxy(1,23);
      if(!mpu_available) vatcprintf("Current MPU-401 midi port is invalid.");
      else vatcprintf("                                               ");
      gotoxy(1,22);
      vatcprintf("                                                    ");
      mpu_checked = TRUE;
    }
    else if(toupper(r) == 'F') {               // Toggle output
      midi_fmout ^= TRUE;
      textcolor(CYAN);
      gotoxy(54,10);
      if(midi_fmout) vatcprintf("ON  ");
      else vatcprintf("OFF ");
    }
    else if(toupper(r) == 'U' && mpu_available) { // Toggle output
      midi_mpuout ^= TRUE;
      textcolor(CYAN);
      gotoxy(55,11);
      if(midi_mpuout) vatcprintf("ON  ");
      else vatcprintf("OFF ");
    }
  }
}


/**************************************************************************
  void bitprint(char byte)

  DESCRIPTION:  Prints individual bits and then a HEX value

**************************************************************************/
void bitprint(unsigned char byte)
{
  int i;

  vatcprintf("  ");
                                    // go through bits
  for(i = 7; i >= 0; i--) {
    if(getbit(byte,i)) {            // 1's are yellow
      textcolor(YELLOW);
      vatcprintf("1");
    }
    else {                          // 0's are dark grey
      textcolor(DARKGRAY);
      vatcprintf("0");
    }
  }

  textcolor(LIGHTBLUE);             // print the hex value
  vatcprintf("  %c%c",hexchar[byte/16],hexchar[byte%16]);
  textcolor(WHITE);
}



/**************************************************************************
  void fmdemo()

  DESCRIPTION:  Allows th user to mess around with instruments and
                play a few notes.


**************************************************************************/
void fmdemo(void)
{
  unsigned int i,cx,cy,voice=0,instrument = 0;
  int drawvoice = 1,rythm = 0,vol;
  char r = 0;

  vol = midi_volume *8;
  if(vol > 63) vol = 63;

  clrscr();                          // clear screen
  vatcprintf("FM demonstration screen");

  gotoxy(1,16);
  vatcprintf("IJKL = cursor movement\r\n");
  vatcprintf("<space> = toggle bit\r\n");
  vatcprintf("numbers = play notes\r\n");
  vatcprintf("v = change voice\r\n");
  vatcprintf("n = Change instrument\r\n");
  vatcprintf("r = toggle rythm mode\r\n");
  vatcprintf("q = quit");

  _setcursortype(_SOLIDCURSOR);
  FMReset();
  for( i = 0; i < 8; i++) {          // initialize voices
    FMSetVoice ( i,inst[instrument]) ;
    FMKeyOff(i);
    FMSetVolume(i,0);
  }

  cx = 54;cy = 5;                    // init cursor position

  for(i = 0; i < 11; i++) {          // print register names
    gotoxy(50-strlen(regname[i]),i+5);
    textcolor(MAGENTA);
    vatcprintf("%s",regname[i]);
  }


  while(r != 'Q') {                  // main input loop
    if(drawvoice) {
      for(i = 0; i < 11; i++) {      // display instrument data
        gotoxy(52,i+5);
        bitprint(inst[instrument][i]);
      }
      for(i = 0; i < 9; i++) {
        FMSetVoice ( i,inst[instrument]) ; // initialize new voice
      }
      drawvoice = 0;
      textcolor(LIGHTGRAY);
      gotoxy(52,4);
      vatcprintf("Instrument #%d ",instrument);
    }

    gotoxy(cx,cy);                   // put cursor in right spot

    while(!kbhit());

    r = toupper(getch());
    if(r >= '0' && r <= '9') {
      FMKeyOff(voice);
      FMSetVoice(voice,inst[instrument]);
      FMSetNote ( voice, (r-'0'+3) * 8) ;
      FMSetVolume(voice,vol);
      FMKeyOn(voice);
    }
    else if(r == 'I') {              // i,j,k,l = cursor movement
      cy = cy -1;
      if(cy<5) cy = 5;
    }
    else if(r == 'K') {
      cy = cy +1;
      if(cy >15) cy = 15;
    }
    else if(r == 'J') {
      cx = cx -1;
      if(cx<54) cx = 54;
    }
    else if(r == 'L') {
      cx = cx +1;
      if(cx>61) cx = 61;
    }
    else if(r == ' ') {              // space = toggle bit
      togbit(inst[instrument][cy-5],(7-(cx-54)));
      drawvoice = 1;
    }
    else if(r == 'N') {              // I = change instrument
      instrument++;
      if(instrument > 8) instrument = 0;
      drawvoice = 1;
    }
    else if(r == 'R') {              // r = toggle rythm mode
      if(rythm) rythm = 0;
      else rythm = 1;
      FMSetRythmMode(rythm);           // do it
      FMRythmOn(FM_HIHAT);
      gotoxy(1,2);                   // tell the user
      if(rythm) vatcprintf("Rythm Mode ON  (voices 6,7,8 only) ");
      else      vatcprintf("Rythm Mode OFF                     ");
    }
    else if(r == 'V') {              //  v = change voice
      FMKeyOff(voice);
      FMSetVolume(voice,0);
      voice ++;
      if(voice > 8) voice = 0;
      gotoxy(1,3);
      vatcprintf("Voice: %d ",voice);
    }

  }
  for(i = 0; i < 9; i++) {
    FMSetVolume(i,0);
  }
  _setcursortype(_NOCURSOR);

}



/**************************************************************************
  void introtext(void)

  DESCRIPTION: Display introduction text for the user.


**************************************************************************/
void introtext(void)
{
  clrscr();
  vatcprintf("Varmint's Audio Tools (Version: %s) Demonstration\r\n",VAT_VERSION);
  vatcprintf("\r\n");
  textcolor(YELLOW);
  vatcprintf("Please edit the file survey.txt and return it to:\r\n");
  vatcprintf("\r\n");
  vatcprintf("     smeagol@rt66.com\r\n");
  vatcprintf("\r\n");
  vatcprintf("Returning this file will help to make VAT more stable and more\r\n");
  vatcprintf("useful for everyone.  If the demo should crash, please run it\r\n");
  vatcprintf("with -debug in the command line.  This will store some useful\r\n");
  vatcprintf("information in the survey.txt file.\r\n");
  vatcprintf("\r\n");
  vatcprintf("Thanks for trying out my library!\r\n");
  vatcprintf("\r\n");
  vatcprintf("\r\n\n                      -Eric Jorgensen\r\n");

  vatcprintf("\n\nPlease press the space bar to continue...");

  while(!kbhit());
  getch();
}


/**************************************************************************
  void diagnostics(void)

  DESCRIPTION:  This prepares survey.txt to receive diagnostic information
                and writes a few introductory things in that file.

**************************************************************************/
void diagnostics(void)
{
  static char *e;

  diagoutput = fopen("survey.txt","w");    // Open survey file
  if(!diagoutput) return;

  printf("\nTesting and recording system configuration.\n");
                                           // Write the survey
  fprintf(diagoutput,"Survey for Varmint's Audio tools.\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"Please email the completed survey to smeagol@rt66.com\n");
  fprintf(diagoutput,"-----------------------------------------------------------------------------\n");
  fprintf(diagoutput,"VERSION %s (beta)\n",VAT_VERSION);
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"1) What's your name and email address?\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"2) How did you hear about Varmint's Audio tools and where did you find\n");
  fprintf(diagoutput,"   this copy?\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"3) Did the demo work on your computer?  If not, please describe what happened.\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"4) Have you tried earlier versions of VAT?  What versions?  Did the demos work?\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"5) Have you been able to use VAT in your own programs?  What features made\n");
  fprintf(diagoutput,"   it easy or difficult to do so?\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"6) Please describe your computer system:\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"                CPU (eg: 386,486,Pentium):\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"          Internal clock speed (eg:66Mhz):\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"        Memory Manager (eg: QEMM, EMM386):\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"  Operating system(eg: DOS/Windows, OS/2):\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"        Sound card (eg: PAS16, GUS, SB16):\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"7) Please add any additional praise or chastisement of Varmint's Audio Tools:\n");

                                            // Print some autodiag info
  fprintf(diagoutput,"\n---------- AUTO DIAGNOSTIC INFORMATION ---------\n");
  fprintf(diagoutput,"Everything below here was written automatically by\n");
  fprintf(diagoutput,"the VAT demo.  Please do not delete these lines.\n");
  fprintf(diagoutput,"-------------------------------------------------\n\n");

  e = getenv("BLASTER");                    // Record BLASTER variable
  if(e) fprintf(diagoutput,"BLASTER env variable: %s\n",e);


                                            // Check available memory
//  fprintf(diagoutput,"Start Core left: %lu\n",farcoreleft());
  fflush(diagoutput);
}


/**************************************************************************
  void debugoptions(void)

  DESCRIPTION: Allows the user to set certain debug options.  These debug
               options will eventually be removed from the code when it
               is debugged.

**************************************************************************/
void debugoptions(void)
{
  char r = 0;

  clrscr();

  textcolor(WHITE);
  vatcprintf("VAT debug options\n");

  textcolor(LIGHTBLUE);

  gotoxy(10,5);
  vatcprintf("1) Force DSP to not use auto-init DMA");
  gotoxy(5,5);
  if(debug_lowdsp) vatcprintf("ON");
  else vatcprintf("OFF");

  gotoxy(10,6);
  vatcprintf("2) Reverse DMA flipflop (kills static on some systems)");
  gotoxy(5,6);
  if(debug_reverseflipflop) vatcprintf("ON");
  else vatcprintf("OFF");


  gotoxy(5,20);
  vatcprintf("Press a number to toggle an option, or Q to quit.");


  textcolor(WHITE);
  while(tolower(r) != 'q') {
    r = toupper(getch());
    if(r == '1') {
      debug_lowdsp ^= TRUE;
      gotoxy(5,5);
      if(debug_lowdsp) vatcprintf("ON  ");
      else vatcprintf("OFF ");
      DropDeadVarmint();                   // activet the interrupt again
      GoVarmint();
    }
    else if(r == '2') {
      debug_reverseflipflop ^= TRUE;
      gotoxy(5,6);
      if(debug_reverseflipflop) vatcprintf("ON  ");
      else vatcprintf("OFF ");
    }
  }
}



char vatoutstring[255];

/**************************************************************************
  void vatcprintf(char *string,...)

  DESCRIPTION:  Special printf function that disables interrupts.  There is
                some concern that interrupting a printf may cause some
                systems to crash.  This is an experimental precaution.

**************************************************************************/
void vatcprintf(char *string,...)
{
  va_list ap;

  _disable();

  va_start(ap, string);                  // sort out variable argument list
  vsprintf(vatoutstring,string,ap);      // dump output to a string
  _outtext(vatoutstring);            // dump string to screen
  va_end(ap);                            // clean up
  _enable();
}
