/*
    Module: cfg_io.h
        Configuration File IO defines and types

    Copyright (c) 1991-92 by Jorgen Sven Abrahamsen (2:230/100.9@fidonet)

    A configuration section is led off by a [tag] on a line by itself.
    A configuration entry is led off by a <tag>, followed by a variable
        number of -<subtags>.

    Reading:
        A cfg_findfirst/cfg_findnext for a cfg entry in section, returns
        a linked list of tokens to be parsed.
                                                                  
    Caveats:
        Sections must have a SECTION_CB as first character, and SECTION_CE
            as last character.
        Subtags must have a OPTION_C as first character.
        Comments are denoted by a COMMENT_C and continue to end of current 
            line. COMMENT_C's inside quotes or escaped (with \) are ignored.

    Programmer : JSA / Cirrus  27-01-1991  Ver. 1.0
*/
/*---------------------------------------------------------------------------*/

#define SECTION_CB          '['
#define SECTION_CE          ']'
#define COMMENT_C           ';'
#define OPTION_C            '-'
#define MAX_CFG_TOKEN_LEN   256

typedef struct _typeCfgEntry typeCfgEntry;

struct _typeCfgEntry {  /* a configuration tag struct */
    const int       id;
    const char      *tag;
    };

typedef struct {        /* A configuration file status struct */
    FILE       *file;
    const typeCfgEntry *entry;
    } typeCfgFile;

typedef struct _typeCfgToken typeCfgToken;

struct _typeCfgToken {  /* a configuration token LL */
    typeCfgToken    *next;
    int             id;
    char            *token;
    };

typeCfgFile * ropencfg(const char *name);
void closecfg(typeCfgFile *cf);
typeCfgToken * cfg_findfirst(typeCfgFile *cf, 
                            const char *section, 
                            const typeCfgEntry *entry);
typeCfgToken * cfg_findnext(typeCfgFile *cf);
void free_cfgtoken(typeCfgToken *head);
