/*
    Module: ms_dir.h
        Include file for MS-DOS directory functions

    Copyright (c) 1991-92 by Jorgen Sven Abrahamsen (2:230/100.9@fidonet)

    Programmer : JSA / Cirrus  25-01-1991  Ver. 1.00
*/
/*---------------------------------------------------------------------------*/
/*
    Defines
*/
#ifndef _FPOS_T_DEFINED
typedef long fpos_t;
#define _FPOS_T_DEFINED
#endif
#ifndef _MAX_PATH
#define _MAX_PATH   260 /* max. length of full pathname */
#endif

/*---------------------------------------------------------------------------*/
/*
    Typedefs
*/
typedef struct _directory_entry typeDirEntry;

struct _directory_entry {   /* A directory entry */
    typeDirEntry *next;
    char    *name;
    unsigned attr;
    fpos_t   size;
    };

typedef struct {    /* Directory structure */
    typeDirEntry *head;
    typeDirEntry *tail;
    } typeDir;

typedef struct {    /* Directory structure for saving/restoring directory */
    int  drive;
    char path[_MAX_PATH];
    } typeSaveDir;

extern const typeDir * ALLFILES;

/*---------------------------------------------------------------------------*/
/*
    Prototypes
*/
typeDir *open_dir(void);
typeDirEntry * read_dir(typeDir *dir, const typeDir *wilds);
typeDirEntry * add_dir_entry(typeDir *dir, const char *name, unsigned attr, fpos_t size);
void close_dir(typeDir *dir);
void kill_dir_tree(const char *path);
fpos_t file_sz(char *filename);
char *get_dir(void);
int set_dir(const char *dir);
