int FMSongPlaying(void);
/* Returns 1 if a song is currently playing, 0 otherwise */

void FMStartSong(BYTE *songData,int speed,int loop1); 
/* Starts a song playing.  Tempo will be divided by `speed'. Use this
to control the speed of the song.  If `loop' is nonzero the song will
play in an infinite loop, pausing for `loop' ticks between iterations. 
*/

void FMStopSong(void);
/* Stops the current song. */

BYTE *FMLoadSong(char *name); 
/* Mallocs some space, loads the named song into it, and returns the
buffer containing the song. (or NULL if couldn't read song or couldn't
malloc the space needed) */

void FMInstallISR(int td);
/* Installs an ISR that calls FMPlayNextTick every timer tick.  Timer
ticks usually occur at 13hz.  This rate will be multiplied by `td' to
allow faster tempoed songs to be played.  You should keep td equal to
1 normally.  */

void FMRemoveISR(void); 
/* Removes the player's ISR.  This should be done before the program
terminates. */

void FMPlayNextTick(void); 
/* Plays next part of song.  Should be called at regular intervals,
FMInstallISR is a nice way to do this.  Calling this when no song is
playing will have no undesirable effects.  */
