{
 This is a simple demonstration how WAV-Soundfile could be played on
 SoundBlaster-compatible cards.
 Especially 16bit output is support for the MV ProSonic16 card and other
 cards with the JAZZ16 chipset.

 Attention! There is not test for SBpro or JAZZ16 !
            IRQ > 7 not supported !

 I better include this one:

 | The author excludes any and all implied warranties, including warranties
 | of merchantability and fitness for a particular purpose. The author
 | should have no liability for special, incidental, or consequential
 | damages arising out or resulting from the use or modification of this
 | source code.

 This source is just to document how to program the JAZZ16 chipset to play
 16bit sound. Don't exspect something special.
 The main play-loop looks quite shitty, I know that!

 You can use this code anyway you want, except for comercial purpose.

 My informations came from:
  c't magazine 1/93 "Sounddatei-Formate" p.213
 "DMA-Tutorial" (FAQ) Tom Marshall
 "Das SoundBlaster Buch" J.Munnik/E.Oostendorp, Sybex-Verlag
 and last but not least: Trial and Error! ;-)

 Any questions,remarks,etc. to:

 Andree Borrmann       eMail:  A.Borrmann@tu-bs.de
 Schopenhauerstr.5
 D-38644 Goslar
}

Program Pros_WAV; {version 1.04}
{$M 4096,0,65500}
Uses DOS,Crt;

Const dma    = 4096; { size of DMA-buffer }

Type  id_t   = Array[1..4] of Char;

			{ WAV-Fileheader structure: }
      riff_t = Record
                R_Ident : id_t;
                length  : Longint;
                C_Ident : id_t;
                S_Ident : id_t;
                s_length: Longint;
                Format  ,
                Modus   : Word;
                freq    ,
                byte_p_s: LongInt;
                byte_sam,
                bit_sam : Word;
                D_Ident : id_t;
                d_length: LongInt;
              End;
      blaster_T = Record
                    port : Word;
                    dmac ,
                    hdmac,
                    irq  : Byte;
                  End;
      buffer_T = Array[1..dma] of Byte;

Var id       : riff_T;
    fn       : String;
    wav      : File;
    endof    : Boolean;
    blaster  : Blaster_T;
    old_irq  : Pointer;
    dma_buf_1,
    dma_buf_2,
    zwi      : ^Buffer_T;
    Channel  : Byte;

Const RIFF : id_t = ('R','I','F','F'); { WAV-header signs }
      WAVE : id_t = ('W','A','V','E');
      FMT_ : id_t = ('f','m','t',' ');
      DATA : id_t = ('d','a','t','a');

      { the following array contains the IO-ports of the DMA-channels 0-7,
        in these order:
           1 : single mask
           2 : clear flipflop
           3 : mode
           4 : channel offset
           5 : channel page
           6 : channel length
      }
      DMA_Dat : Array [0..7,1..6] of Byte=
                  (($A,$C,$B,$0,$87,$1),
                   ($A,$C,$B,$2,$83,$3),
                   ($A,$C,$B,$4,$81,$5),
                   ($A,$C,$B,$6,$82,$7),
                   ($D4,$D8,$D6,$C0,$8F,$C2),
                   ($D4,$D8,$D6,$C4,$8B,$C6),
                   ($D4,$D8,$D6,$C8,$89,$CA),
                   ($D4,$D8,$D6,$CC,$8A,$CE));

{ Blaster_commands sends a command/data byte to the DSP-command register }
Procedure Blaster_Command(c :Byte); Assembler;
Asm
    Mov dx,Word Ptr Blaster.port
    Add dx,$c
 @t:In al,dx
    And al,128
    Jnz @t
    Mov al,c
    Out dx,al
End;

{ Init_SB resets the soundcard and turns on output (DSP $d1) }
Procedure Init_SB(base : Word);
Var w,w2:Word;
Begin
  Port[base+6]:=1; Delay(4); Port[base+6]:=0; w:=0; w2:=0;
  Repeat
    Repeat Inc(w); Until ((Port[base+$e] and 128)=128) or (w>29);
    Inc(w2);
  Until (Port[base+$a]=$AA) or (W2>30);
  If w2>30 then
    Begin
      WriteLn('Failed to reset blaster');
      Halt(128);
    End;
  Blaster_Command($d1);
End;

{ Set_stereo sets the stereo-bit of the SBpro/ProSonic mixer }
Procedure Set_Stereo; Assembler;
Asm
  Mov dx,Word Ptr Blaster.port
  Add dx,$4 { mixer select is at baseport+4 }
  Mov al,$e { stereo bit located in mixer-register $e }
  Out dx,al
  Inc dx    { mixer read/write is at baseport+5 }
  In al,dx
  And al,253
  Or al,2
  Out dx,al
End;

{ Clear_stereo sets the stereo-bit of the SBpro/ProSonic mixer }
Procedure Clear_Stereo; Assembler;
Asm
  Mov dx,Word Ptr Blaster.port
  Add dx,$4
  Mov al,$e
  Out dx,al
  idiv al
  Inc dx
  In al,dx
  And al,253
  Out dx,al
End;

{ No_wave tests for WAV-header signs.
  False if signs are correct! }
Function No_Wave(Var id:riff_T):Boolean;
Begin
  With id do
    No_Wave:=(R_Ident<>RIFF) or
             (C_Ident<>WAVE) or
             (S_Ident<>FMT_) or
             (D_Ident<>DATA);
End;

{ Initialize soundcard, test file, print information}
Procedure Init;
Var b        : Byte;
    BlastEnv : String;
Begin
  WriteLn;
  WriteLn('ProSonic WAV-Player 16bit        (p) 22.06.95 A.Borrmann');
  Blaster.Port:=0;
  Blaster.dmac:=0;
  Blaster.hdmac:=0;
  Blaster.irq:=0;
  BlastEnv:=GetEnv('BLASTER');
  If BlastEnv='' then
    Begin
      WriteLn('BLASTER must be set...');
      Halt(100);
    End;
  b:=1;
  Repeat
    Case BlastEnv[b] of
      'A' : Repeat
              Inc(b);
              Blaster.Port:=Blaster.Port*16+Ord(BlastEnv[b])-48;
            Until BlastEnv[b+1]=' ';
      'D' : Begin
              Blaster.DMAc:=Ord(BlastEnv[b+1])-48;
              Inc(b,2);
            End;
      'I' : Repeat
              Inc(b);
              Blaster.IRQ:=Blaster.IRQ*10+Ord(BlastEnv[b])-48;
            Until BlastEnv[b+1]=' ';
      'H' : Begin
              Blaster.hDMAc:=Ord(BlastEnv[b+1])-48;
              Inc(b,2);
            End;
        End;
    Inc(b);
  Until b>Length(BlastEnv);
  With Blaster do
    WriteLn('Blaster : P',Port,'  I',irq,'  D',dmac,'  H',hdmac);
  Init_SB(Blaster.Port);
  If ParamCount>0 then
    fn:=ParamStr(1)
  Else
    Begin
      Write('WAV-File: ');
      ReadLn(fn);
    End;
  Assign(wav,fN);
  {$I-} ReSet(wav,1); {$I+}
  If IOResult<>0 then
    Begin
      WriteLn('File "',fn,'" not found!');
      Halt(2);
    End;
  BlockRead(wav,id,Sizeof(id));
  If no_Wave(id) then
    Begin
      WriteLn('"',fn,'" seems to be no WAVE-File...');
      Halt(128);
    End;
  Write('Wave    : ',id.bit_sam,'bit ');
  If id.Modus=2 then
    Begin
      Set_Stereo;
      Write('stereo ');
    End
  Else
    Begin
      Clear_Stereo;
      Write('mono    ');
    End;
  { if 16bit sample and 16bit DMA-channel specified, use it!}
  If (id.bit_sam>8) and (Blaster.hdmac>3) then
    Channel:=Blaster.hdmac
  Else Channel:=Blaster.dmac;
  WriteLn(id.freq,' Hz  ',id.byte_p_s,' Bytes/Sec');
  WriteLn('Length  : ',id.d_length,' Bytes    ',id.d_length div id.byte_p_s, ' Sec');
  WriteLn('Playing : ',fn);
End;

{ Initialize DMA-Controller, start DMA-transfer }
{$F+}
Procedure Set_DMA(Freq: Word;Var size : Word);
Var PageNr,PageAdress,DMALength: Word;
Begin
  Inline($FA);
  { Calculate linear address from segment:offset }
  Asm
    Mov ax,Word Ptr DMA_Buf_1[2]
    Shr ax,12
    Mov Word Ptr PageNr,ax
    Mov ax,Word Ptr DMA_Buf_1[2]
    Shl ax,4
    Mov Word Ptr PageAdress,ax
    Mov ax,Word Ptr DMA_Buf_1
    Add Word Ptr PageAdress,ax
    Adc Word Ptr PageNr,0
  End;
  DMALength:=Size;

  Freq:=256-Round(1000000/Freq);

  If Channel>3 then { => 16bit is WORD aligned! }
    Begin
      DMALength:=DMALength div 2;
      PageAdress:=PageAdress div 2;
      If Odd(PageNr) then
        Begin
          Dec(PageNr);
          PageAdress:=PageAdress+$8000
        End;
    End;
  If id.Modus=2 then 							{ stereo?}
    Begin
      If id.bit_sam=16 						{ 16bit? }
        then Blaster_Command($A4) { the ProSonic 16bit command!!!
                                    stereo bit at mixer decides whether it
                                    is mono or stereo. }
        Else Blaster_Command($A8);{ standard SB stereo command    }
    End
  Else
    If id.bit_sam=16
      then Blaster_Command($A4);{ the ProSonic 16bit command!!!
                                    stereo bit at mixer decides whether it
                                    is mono or stereo. }

  Dec(DMALength);

  { Init DMA: }
  Port[DMA_dat[Channel,1]]:=$4 or (Channel and $3); { mask channel       }
  Port[DMA_dat[Channel,2]]:=$0;                     { clear flipflop     }
  Port[DMA_dat[Channel,3]]:=$49;                    { set transfermode   }
  Port[DMA_dat[Channel,4]]:=lo(PageAdress);         { set start-address  }
  Port[DMA_dat[Channel,4]]:=hi(PageAdress);
  Port[DMA_dat[Channel,5]]:=lo(PageNr);
  Port[DMA_dat[Channel,6]]:=lo(DMALength);          { set length         }
  Port[DMA_dat[Channel,6]]:=hi(DMALength);
  Port[DMA_dat[Channel,1]]:=(Channel and $3);       { enable channel     }

  Blaster_Command($40);                             { set sample-rate    }
  Blaster_Command(Lo(Freq));
  If Id.Modus=1 then                       { just for SB 1.0 compability }
    Begin
      Blaster_Command($14);                { command $14 is used }
			Blaster_Command(lo(DMALength));
      Blaster_Command(hi(DMALength));
    End
  Else
    Begin
      Blaster_Command($48);                { set transfer-length }
      Blaster_Command(lo(DMALength));
      Blaster_Command(hi(DMALength));
      Blaster_Command($91);                { single Block high speed }
    End;
  Inline($FB);
End;

{ The interrupt-handler: }
Procedure SB_IRQ; Interrupt;
Var test : Byte;
Begin
  Inline($FA);
  Port[$20]:=$20;               { recognize IRQ  (IRQ-controller) }
  test:=Port[Blaster.port+$e];  { recognize IRQ  (soundcard) }
  endof:=True;
  Inline($fB);
End;
{$F-}

{ Play the wav-file: }
Procedure Play;
Var p,s,s2 : Word;
    freq   : LongInt;
Begin

  { Get DMA-double-buffer without page crossing: }
  GetMem(zwi,16);
  GetMem(dma_buf_1,dma);
  p:=16;
  While ((Seg(dma_buf_1^[1]) mod 4096)>(4096-(dma*2 div 16))) do
    Begin
      FreeMem(dma_buf_1,dma);
      FreeMem(zwi,p);
      p:=p+16;
      If p>65525 then halt(111);
      GetMem(zwi,p);
      GetMem(dma_buf_1,dma);
    End;
  GetMem(dma_buf_2,dma);
  FreeMem(zwi,p);


  { set interrupt-vector to own handler: }
  GetIntVec(Blaster.IRQ+8,old_irq);
  SetIntVec(Blaster.IRQ+8,@SB_IRQ);
  { enable interrupt: }
  port[$21]:=Port[$21] and (255 xor (1 shl Blaster.IRQ));

  freq:=id.freq*id.modus;


  { Read file and play until EoF or keypressed }
  BlockRead(wav,dma_buf_1^[1],dma,s);
  Repeat
    endof:=False;
    Set_DMA(freq,s);
    BlockRead(wav,dma_buf_2^[1],dma,s2);
    Repeat Until endof;
    { swap buffers }
    s:=s2;
    zwi:=dma_buf_1;
    dma_buf_1:=dma_buf_2;
    dma_buf_2:=zwi;
  Until EoF(wav) or Keypressed;

  While KeyPressed do  s2:=Ord(ReadKey);
  If EoF(wav) then  { The last block is not played yet }
    Begin
      endof:=False;
      Set_DMA(freq,s);
      Repeat Until endof;
    End;

  { Set the old interrupt-vector }
  SetintVec(Blaster.IRQ+8,old_IRQ);
  {free memory }
  FreeMem(dma_buf_1,dma);
  FreeMem(dma_buf_2,dma);
  { disable interrupt }
  Port[$21]:=Port[$21] or (1 shl Blaster.IRQ);
  { disable output on soundcard }
  Blaster_Command($d3);
End;

Begin
  Init;
  Play;
End.