/*           Copyright 1995 by Ethan Brodsky.  All rights reserved          */

/* sbplay.c */

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mem.h>

#include "sbio.h"
#include "xms.h"

#define BASEIO 0x220
#define IRQ    5
#define DMA16  5

#define LOAD_CHUNK_SIZE 8192
#define BLOCK_LENGTH    256

#define FALSE 0
#define TRUE  1

int (far *bufptr)[2][BLOCK_LENGTH] = NULL;

unsigned int rate;
char filename[64] = "";

long numsamples;

int  handle;
long cursample;

MOVEPARAMS moveparams;

int getparameters
 (int argc, char *argv[], unsigned int *rate, char *fname)
  {
    if (argc != 3) /* The program name counts as an argument */
      return FALSE;
    else
      {
        if ((*rate = atoi(argv[1])) == 0) return FALSE;
        strcpy(fname, argv[2]);
        return TRUE;
      }
  }

void loaddata(void)
  {
    FILE *f;
    char chunk[LOAD_CHUNK_SIZE];
    long size;

    if ((f = fopen(filename, "rb")) == NULL)
      {
        printf("Error opening %s!\n", *filename);
        exit(EXIT_FAILURE);
      }

    fseek(f, 0, SEEK_END); /* Move to end of file */
    size = ftell(f);       /* File size = end pos */
    fseek(f, 0, SEEK_SET); /* Back to begining    */
    numsamples = size / 2; /* 16-bit samples      */

    xms_init();
    if (!xms_allocate(&handle, (unsigned int)((size / 1024) + 1)))
      {
        printf("ERROR:  Not enough free XMS!\n");
        printf("        Bytes required:  %u\n", size);
        printf("        Bytes free:      %u\n", xms_getfreemem()*1024);
        exit(EXIT_FAILURE);
      }
    else
      {
        moveparams.sourcehandle = 0;
        moveparams.sourceoffset = (long)(&chunk);
        moveparams.desthandle   = handle;
        moveparams.destoffset   = 0;

        do
          {
            moveparams.length = fread(&chunk, 1, LOAD_CHUNK_SIZE, f);
            xms_move(&moveparams);
            moveparams.destoffset += moveparams.length;
            size -= moveparams.length;
          }
        while (size > 0);

        fclose(f);
      }
  }

void copyblock(char blocknum)
  {
    int length;

    if ((cursample + BLOCK_LENGTH) <= numsamples)
      length = BLOCK_LENGTH*2;
    else
      {
        length = (int)(numsamples-cursample) * 2;
        memset((void *)(&(*bufptr)[blocknum][length/2]), 0x00, (BLOCK_LENGTH-(length/2)) * 2);
      }
    moveparams.length       = length;
    moveparams.sourcehandle = handle;
    moveparams.sourceoffset = cursample*2;
    moveparams.desthandle   = 0;
    moveparams.destoffset   = (long)((*bufptr)[blocknum]);

    xms_move(&moveparams);

    cursample += BLOCK_LENGTH;
  }

void far playhandler(void)
  {
    if (cursample < numsamples)
      copyblock(curblock);
    else
      memset((void *)((*bufptr)[curblock]), 0x00, BLOCK_LENGTH*2);
  }

void init(void)
  {
    loaddata();
    getbuffer(&(int far *)bufptr, BLOCK_LENGTH);

    cursample = 0;

    memset((void *)bufptr, 0xFF, sizeof(*bufptr));
    copyblock(0);
    copyblock(1);

    sethandler(playhandler);
    init_sb(BASEIO, IRQ, DMA16, output, rate);
    startio(numsamples);
  }

void shutdown(void)
  {
    shutdown_sb();
    sethandler(NULL);
    freebuffer(&(int far *)bufptr);

    xms_free(&handle);
  }

int main(int argc, char *argv[])
  {
    printf("SBPLAY - Copyright 1995 by Ethan Brodsky.  All rights reserved\n");

    if (getparameters(argc, argv, &rate, filename))
      printf("Playing %s at %u HZ\n", filename, rate);
    else
      {
        printf("Syntax:  sbrecord <rate> <filename>\n");
        printf("Example: sbrecord 22050 data.raw\n");
        exit(EXIT_FAILURE);
      }

    init();

    while (!(done || kbhit()));

    if (kbhit())
      {
        printf("Output terminated by keypress\n");
        getch();
      }

    shutdown();

    printf("\n");

    return(EXIT_SUCCESS);
  }
