/*           Copyright 1995 by Ethan Brodsky.  All rights reserved          */

/* sbrecord.c */

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sbio.h"
#include "xms.h"

#define BASEIO 0x220
#define IRQ    5
#define DMA16  5

#define SAVE_CHUNK_SIZE 8192
#define BLOCK_LENGTH    256

#define FALSE 0
#define TRUE  1

int (far *bufptr)[2][BLOCK_LENGTH] = NULL;

float time;
unsigned int rate;
char  filename[64] = "";

long  numsamples;

int   handle;
long  curoffset;
long  datasize;

int getparameters(int argc, char *argv[], float *time, unsigned int *rate, char *fname)
  {
    if (argc != 4) /* The program name counts as an argument */
      return FALSE;
      else
        {
          if ((*time = atof(argv[1])) == 0.0) return FALSE;
          if ((*rate = atoi(argv[2])) == 0)   return FALSE;
          strcpy(fname, argv[3]);
          return TRUE;
        }
  }

MOVEPARAMS save_moveparams;
void savedata(void)
  {
    FILE *f;
    char chunk[SAVE_CHUNK_SIZE];

    if ((f = fopen(filename, "wb")) == NULL)
      {
        printf("Error opening %s!\n", *filename);
        exit(EXIT_FAILURE);
      }

    save_moveparams.sourcehandle = handle;
    save_moveparams.sourceoffset = 0;
    save_moveparams.desthandle   = 0;
    save_moveparams.destoffset   = (long)(&chunk);

    memset(&chunk, 0x00, SAVE_CHUNK_SIZE);

    while (datasize)
      {
        save_moveparams.length = /* min(SAVE_CHUNK_SIZE, datasize) */
          (datasize > SAVE_CHUNK_SIZE) ? SAVE_CHUNK_SIZE : datasize;
        xms_move(&save_moveparams);
        fwrite(&chunk, 1, (size_t)save_moveparams.length, f);
        save_moveparams.sourceoffset += save_moveparams.length;
        datasize -= save_moveparams.length;
      }

    fclose(f);
  }


MOVEPARAMS record_moveparams;
void far recordhandler(void)
  {
    if (curoffset < datasize)
      {
        record_moveparams.length =
          ((curoffset+BLOCK_LENGTH*2) <= datasize) ? (BLOCK_LENGTH*2) : (datasize - curoffset);
        record_moveparams.sourcehandle = 0;
        record_moveparams.sourceoffset = (long)((*bufptr)[curblock]);
        record_moveparams.desthandle   = handle;
        record_moveparams.destoffset   = curoffset;

        xms_move(&record_moveparams);
        curoffset += BLOCK_LENGTH*2;
      }
  }

void init(void)
  {
    getbuffer(&(int far *)bufptr, BLOCK_LENGTH);
    numsamples = time*rate;

    xms_init();
    datasize = numsamples * 2;

    if (xms_allocate(&handle, (unsigned int)((datasize / 1024) + 1)))
      {
        curoffset = 0;

        sethandler(recordhandler);
        init_sb(BASEIO, IRQ, DMA16, input, rate);
        startio(numsamples);
      }
    else
      {
        printf("ERROR:  Not enough free XMS!\n");
        printf("        Bytes required:  %u\n", 2 * numsamples);
        printf("        Bytes free:      %u\n", 1024 * xms_getfreemem());
        exit(EXIT_FAILURE);
      }
  }

void shutdown(void)
  {
    shutdown_sb();
    sethandler(NULL);
    freebuffer(&(int far *)bufptr);

    xms_free(&handle);
  }

int main(int argc, char *argv[])
  {
    printf("SBRECORD - Copyright 1995 by Ethan Brodsky.  All rights reserved.\n");

    if (getparameters(argc, argv, &time, &rate, filename))
      printf("Recording for %.2f seconds at %u HZ to %s\n", time, rate, filename);
    else
       {
         printf("Syntax:  sbrecord <time> <rate> <filename>\n");
         printf("Example: sbrecord 2.0 22050 test.raw\n");
         exit(EXIT_FAILURE);
       }

    init();

    while (!(done || kbhit()));

    if (done)
      savedata();

    if (kbhit())
      {
        printf("Recording canceled by keypress\n");
        getch();
      }

    shutdown();

    printf("\n");

    return(EXIT_SUCCESS);
  }