{           Copyright 1995 by Ethan Brodsky.  All rights reserved.           }
program SBRecord; {$X+}
  uses
    CRT,
    DOS,
    SBIO,
    XMS;
  const
    BaseIO = $220;
    IRQ    = 5;
    DMA16  = 5;
    SaveChunkSize = 8192;
    BlockLength   = 256;
  type
    PBuffer = ^TBuffer;
    TBuffer = array[1..2] of array[1..BlockLength] of integer;
  var
    Time: real;
    Rate: word;
    FileName: string;

    NumSamples: LongInt;
    Buffer: PBuffer;

    Handle: word;
    CurOffset: LongInt;
    DataSize: LongInt;

  function GetParameters(var Time: real; var Rate: word; var FName: string): boolean;
    var
      Code: integer;
      i: byte;
    begin
      GetParameters := false;
      if ParamCount <> 3
        then
          Exit
        else
          begin
            Val(ParamStr(1), Time, Code);
            if Code <> 0 then Exit;

            Val(ParamStr(2), Rate, Code);
            if Code <> 0 then Exit;

            FName := ParamStr(3);
            for i := 1 to Length(FName) do FName[i] := UpCase(FName[i]);
            GetParameters := true;
          end;
    end;

  var
    RecordMoveParams: TMoveParams;
  procedure RecordHandler; far;
    begin
      if CurOffset < DataSize
        then
          begin
            with RecordMoveParams do
              begin
                if (CurOffset+BlockLength*2) <= DataSize
                  then Length := BlockLength*2
                  else Length := DataSize-CurOffset;
                SourceHandle  := 0;
                SourceOffset  := LongInt(@(Buffer^[CurBlock]));
                DestHandle    := Handle;
                DestOffset    := CurOffset;
              end;
            XMSMove(@RecordMoveParams);
            Inc(CurOffset, BlockLength*2);
          end;
    end;

  var
    SaveMoveParams: TMoveParams;
  procedure WriteData;
    type IntArray = array[1..SaveChunkSize div 2] of integer;
    var
      f: file;
      Chunk: array[1..SaveChunkSize] of byte;
    begin
      Assign(f, FileName);  ReWrite(f, 1);

      with SaveMoveParams do
        begin
          SourceHandle := Handle;
          SourceOffset := 0;
          DestHandle   := 0;
          DestOffset   := LongInt(Addr(Chunk));
        end;

      while DataSize > 0 do
        begin
          if DataSize > SaveChunkSize
            then SaveMoveParams.Length := SaveChunkSize
            else SaveMoveParams.Length := DataSize;
          XMSMove(@SaveMoveParams);
          BlockWrite(f, Chunk, SaveMoveParams.Length);
          Inc(SaveMoveParams.SourceOffset, SaveMoveParams.Length);
          Dec(DataSize, SaveMoveParams.Length);
        end;

      Close(f);
    end;

  procedure Init;
    begin
      GetBuffer(pointer(Buffer), BlockLength);

      NumSamples := Round(Time*Rate);

      XMSInit;
      DataSize := NumSamples * 2;
      if not(XMSAllocate(Handle, (DataSize div 1024)+1))
        then
          begin
            writeln('ERROR:  Not enough free XMS');
            writeln('        Bytes required:  ', 2 * NumSamples);
            writeln('        Bytes free:      ', XMSGetFreeMem * 1024);
            Halt(2);
          end;

      CurOffset := 0;

      FillChar(Buffer^, SizeOf(Buffer^), $FF);

      SetHandler(@RecordHandler);
      SBIO.Init(BaseIO, IRQ, DMA16, Input, Rate);
      StartIO(NumSamples);
    end;

  procedure Shutdown;
    begin
      SBIO.Shutdown;
      SetHandler(nil);
      FreeBuffer(pointer(Buffer));
    end;

  begin
    writeln('SBRECORD - Copyright 1995 by Ethan Brodsky.  All rights reserved.');
    if GetParameters(Time, Rate, FileName)
      then
        writeln('Recording for ', Time:0:2, ' seconds at ', Rate, ' HZ to ', FileName)
      else
        begin
          writeln('Syntax:  sbrecord <time> <rate> <filename>');
          writeln('Example: sbrecord 2.0 22050 test.raw');
          Halt(1);
        end;

    Init;

    repeat until Done or KeyPressed;

    if KeyPressed
      then
        begin
          writeln('Recording canceled by keypress');
          ReadKey;
          ShutDown
        end
      else
        begin
          Shutdown;
          WriteData;
        end;

    XMSFree(Handle);

    writeln;
  end.