program Mix16Tst;
  uses
    SB16Mixr;
  const
    PreserveMixerState = false;
      {If set to true, the mixer state will be restored when this program}
      {terminates.  (See below)  Any changes made to the mixer's settings}
      {will be undone on return to DOS.  This is considered good behavior}
      {for any program that modifies mixer registers.  I have left it off}
      {so that you can see what this program does by using SB16SET.      }
    BaseIO = $220;
    Reset = true;

   {Volumes}
    vMaster_L = 24;  vMaster_R = 24;
    vVoice_L  = 24;  vVoice_R  = 24;
    vFM_L     = 24;  vFM_R     = 24;
    vCD_L     = 24;  vCD_R     = 24;
    vLine_L   = 24;  vLine_R   = 24;
    vMic       = 24;
    vPCSpeaker = 3;

   {Mixing switches}
    Output  = {Mic +} CD_R + CD_L + Line_R + Line_L;
    Input_L = Mic + CD_L + Line_L + FM_L {+ CD_R + Line_R + FM_R};
    Input_R = Mic + CD_R + Line_R + FM_R {+ CD_L + Line_L + FM_L};

   {Gain settings}
    InputGain_L  = 0;  InputGain_R  = 0;
    OutputGain_L = 1;  OutputGain_R = 1;
    MicAGC = On;

   {Treble and bass adjustment}
    Treble_L = 08;  Treble_R = 08;
    Bass_L   = 08;  Bass_R   = 08;
  begin
    InitMixer(BaseIO);

    if PreserveMixerState then SaveMixerState;
    if Reset then ResetMixer;

    SetMasterVolume(vMaster_L, vMaster_R);
    SetVoiceVolume(vVoice_L, vVoice_R);
    SetFMVolume(vFM_L, vFM_R);
    SetCDVolume(vCD_L, vCD_R);
    SetLineVolume(vLine_L, vLine_R);
    SetMicVolume(vMic);
    SetPCSpeakerVolume(vPCSpeaker);

    SetOutputMixer(Output);
    SetInputMixer(Input_L, Input_R);

    SetInputGain(InputGain_L, InputGain_R);
    SetOutputGain(OutputGain_L, OutputGain_R);
    SetMicAGC(MicAGC);

    SetTreble(Treble_L, Treble_R);
    SetBass(Bass_L, Bass_R);

    if PreserveMixerState then RestoreMixerState;
  end.
